/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.mixin;

import com.macuguita.backpacks.GBConfig;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerMixin {

	@Inject(
			method = "dropEquipment",
			at = @At("TAIL")
	)
	private void gbackpacks$dropInventory(CallbackInfo info) {
		if (EquipmentUtils.isTrinketsLoaded()) return;
		if (Boolean.FALSE.equals(GBConfig.getBackpackDropsOnDeath())) return;
		class_1657 player = (class_1657) (Object) this;
		boolean keepInv = ((class_3218) player.method_73183()).method_64395().method_8355(class_1928.field_19389);

		class_1799 stack = EquipmentUtils.getEquippedBackpack(player);
		if (!keepInv && !stack.method_7960()) {
			player.method_7329(stack.method_7972(), true, false);
			GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get(player).clearInventory();
		}
	}
}
