/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.client.gui.widgets;

import com.macuguita.backpacks.common.GuitaBackpacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ScrollBarWidget
extends class_339 {
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED_TEXTURE = class_2960.method_60656((String)"container/creative_inventory/scroller_disabled");
    private static final class_2960 SCROLLER_BACK_TEXTURE = GuitaBackpacks.res("scroll_back");
    public static final int SCROLLER_WIDTH = 12;
    public static final int BACKGROUND_WIDTH = 14;
    public static final int SCROLLER_HEIGHT = 15;
    private final int innerHeight;
    final ScrollCallback callback;
    private float scrollPercent = 0.0f;
    private boolean scrolling = false;

    public ScrollBarWidget(int x, int y, int height, ScrollCallback callback) {
        super(x, y, 14, height + 2, (class_2561)class_2561.method_43473());
        this.callback = callback;
        this.innerHeight = height;
    }

    public ScrollCallback getCallback() {
        return this.callback;
    }

    protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.method_46426();
        int y = this.method_46427();
        context.method_52706(class_10799.field_56883, SCROLLER_BACK_TEXTURE, x, y, this.field_22758, this.field_22759);
        int scrollerX = x + (this.field_22758 - 12) / 2;
        int scrollerY = this.innerHeight <= 15 ? y + 1 : y + 1 + (int)(this.scrollPercent * (float)(this.innerHeight - 15));
        class_2960 scrollerTexture = this.callback.canScroll() ? SCROLLER_TEXTURE : SCROLLER_DISABLED_TEXTURE;
        context.method_52706(class_10799.field_56883, scrollerTexture, scrollerX, scrollerY, 12, 15);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (!this.callback.canScroll() || click.method_74245() != 0) {
            return super.method_25402(click, doubled);
        }
        if (!doubled) {
            this.scrolling = true;
            int currentScrollerY = this.innerHeight <= 15 ? this.method_46427() + 1 : this.method_46427() + 1 + (int)(this.scrollPercent * (float)(this.innerHeight - 15));
            if (click.comp_4799() >= (double)currentScrollerY && click.comp_4799() <= (double)(currentScrollerY + 15)) {
                return true;
            }
            this.updateScroll(click.comp_4799(), true);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.scrolling && this.callback.canScroll()) {
            this.updateScroll(click.comp_4799(), false);
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(@NotNull class_11909 click) {
        if (click.method_74245() == 0) {
            this.scrolling = false;
        }
        return super.method_25406(click);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.callback.canScroll() && this.method_25405(mouseX, mouseY)) {
            int scrollDirection = verticalAmount > 0.0 ? -1 : 1;
            this.callback.onScroll(scrollDirection);
            this.updateScrollPercent();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void updateScroll(double mouseY, boolean snap) {
        float position;
        if (this.innerHeight <= 15) {
            position = 0.0f;
        } else {
            float denom = this.innerHeight - 15;
            position = ((float)mouseY - (float)(this.method_46427() + 1) - 7.5f) / denom;
            position = class_3532.method_15363((float)position, (float)0.0f, (float)1.0f);
        }
        int maxOffset = this.callback.getMaxScrollOffset();
        int targetOffset = Math.round(position * (float)maxOffset);
        int currentOffset = this.callback.getCurrentScrollOffset();
        if (targetOffset != currentOffset || snap) {
            this.callback.scrollTo(targetOffset);
            this.scrollPercent = maxOffset > 0 ? (float)targetOffset / (float)maxOffset : 0.0f;
        }
    }

    public void updateScrollPercent() {
        int maxOffset = this.callback.getMaxScrollOffset();
        int currentOffset = this.callback.getCurrentScrollOffset();
        this.scrollPercent = maxOffset > 0 ? (float)currentOffset / (float)maxOffset : 0.0f;
    }

    protected void method_47399(@NotNull class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"narration.gbackpacks.scroll_bar"));
    }

    public static interface ScrollCallback {
        public void onScroll(int var1);

        public void scrollTo(int var1);

        public int getMaxScrollOffset();

        public int getCurrentScrollOffset();

        public boolean canScroll();
    }
}

