/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.components;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import com.macuguita.backpacks.GBConfig;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_269;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public class BackpacksComponent implements Component {

	private final Map<UUID, class_1277> backpacks = new HashMap<>();

	public BackpacksComponent(class_269 provider, @Nullable MinecraftServer server) {
	}

	public void removeBackpack(UUID uuid) {
		backpacks.remove(uuid);
	}

	public void addInventory(UUID uuid) {
		assert GBConfig.getDefaultBackpackSize() != null;
		if (uuid == null) return;
		addInventory(uuid, GBConfig.getDefaultBackpackSize());
	}

	public void addInventory(UUID uuid, int size) {
		if (uuid == null) return;
		backpacks.put(uuid, new class_1277(size));
	}

	public class_1277 getInventory(UUID uuid) {
		if (uuid == null) return null;
		return backpacks.get(uuid);
	}

	public boolean growBackpack(UUID uuid, int newSize) {
		if (uuid == null) return false;
		class_1277 oldInventory = backpacks.get(uuid);

		if (oldInventory != null) {
			int oldSize = oldInventory.method_5439();
			if (newSize <= oldSize) return false;

			class_1277 newInventory = new class_1277(newSize);
			for (int i = 0; i < oldSize; i++) {
				newInventory.method_5447(i, oldInventory.method_5438(i));
			}

			backpacks.put(uuid, newInventory);
			return true;
		}

		return false;
	}

	@Override
	public void readData(class_11368 readView) {
		backpacks.clear();
		class_11368.class_11370 backpacksList = readView.method_71438("Backpacks");

		for (class_11368 backpackReadView : backpacksList) {
			Optional<UUID> uuid = backpackReadView.method_71426("UUID", class_4844.field_40825);
			int size = backpackReadView.method_71424("Size", 0);

			class_1277 inventory = new class_1277(size);
			class_1262.method_5429(backpackReadView, inventory.field_5828);
			backpacks.put(uuid.orElse(null), inventory);
		}
	}

	@Override
	public void writeData(class_11372 writeView) {
		class_11372.class_11374 backpacksList = writeView.method_71476("Backpacks");

		for (Map.Entry<UUID, class_1277> entry : backpacks.entrySet()) {
			UUID uuid = entry.getKey();
			class_1277 inventory = entry.getValue();

			class_11372 backpackView = backpacksList.method_71480();

			backpackView.method_71468("UUID", class_4844.field_40825, uuid);
			backpackView.method_71465("Size", inventory.method_5439());

			class_1262.method_5426(backpackView, inventory.field_5828);
		}
	}
}
