/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.common.utils;

import java.util.List;
import java.util.UUID;

import com.macuguita.backpacks.common.reg.GBComponents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

public class BackpackUtils {

	public static void checkForDuplicateBackpacks(class_1657 player, UUID backpackUuid, class_1799 backpack) {
		class_1661 inv = player.method_31548();
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 other = inv.method_5438(i);
			if (other == backpack) continue;
			if (other.method_57826(GBComponents.BACKPACK_UUID.get())) {
				UUID otherUuid = other.method_58694(GBComponents.BACKPACK_UUID.get());
				if (backpackUuid.equals(otherUuid)) {
					other.method_57381(GBComponents.BACKPACK_UUID.get());
				}
			}
		}
	}

	public static void dedupeBackpackItemEntity(class_1542 newEntity) {
		class_1799 newStack = newEntity.method_6983();
		if (!newStack.method_57826(GBComponents.BACKPACK_UUID.get())) return;

		UUID newUuid = newStack.method_58694(GBComponents.BACKPACK_UUID.get());

		List<class_1542> nearby = newEntity.method_73183().method_8390(
				class_1542.class,
				newEntity.method_5829().method_1014(10),
				class_1297::method_5805
		);

		for (class_1542 otherEntity : nearby) {
			if (otherEntity == newEntity) continue;
			class_1799 otherStack = otherEntity.method_6983();
			if (otherStack.method_57826(GBComponents.BACKPACK_UUID.get())) {
				UUID otherUuid = otherStack.method_58694(GBComponents.BACKPACK_UUID.get());
				if (newUuid != null && newUuid.equals(otherUuid)) {
					newStack.method_57381(GBComponents.BACKPACK_UUID.get());
					break;
				}
			}
		}
	}

	public static class DeduplicateBackpacks implements ServerEntityEvents.Load {

		@Override
		public void onLoad(class_1297 entity, class_3218 serverWorld) {
			if (!(entity instanceof class_1542 itemEntity)) return;

			class_1799 stack = itemEntity.method_6983();
			if (!stack.method_57826(GBComponents.BACKPACK_UUID.get())) return;

			dedupeBackpackItemEntity(itemEntity);
		}
	}
}
