/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.client.render;

import com.macuguita.backpacks.client.model.GBModelLoadingPlugin;
import com.macuguita.backpacks.client.render.GpuTexture;
import com.macuguita.backpacks.client.render.state.BlockStateGuiElementRenderState;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_2350;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class BlockStateGuiRenderer
extends class_11239<BlockStateGuiElementRenderState> {
    public static int MAX = 6;
    private int allocate = MAX;
    private static final Deque<GpuTexture> TEXTURES = new ArrayDeque<GpuTexture>(MAX);
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public BlockStateGuiRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public Class<BlockStateGuiElementRenderState> method_70903() {
        return BlockStateGuiElementRenderState.class;
    }

    public void render(BlockStateGuiElementRenderState element, class_11246 guiState, int windowScaleFactor) {
        GpuTexture texture;
        class_310 mc = class_310.method_1551();
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.forEach(GpuTexture::close);
            TEXTURES.clear();
            this.allocate = MAX;
        }
        int size = 27 * windowScaleFactor;
        if (this.allocate > 0) {
            --this.allocate;
            texture = GpuTexture.create(size);
        } else {
            texture = TEXTURES.poll();
            assert (texture != null);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092((float)size, (float)size), (class_10366)class_10366.field_54954);
        texture.prepare();
        this.matrices.method_22903();
        this.matrices.method_46416((float)size / 2.0f, (float)size, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.method_22905(scale, scale, scale);
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-30.0f));
        this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(45.0f));
        this.matrices.method_46416(-0.5f, -0.5f, -0.5f);
        this.matrices.method_22905(1.0f, -1.0f, 1.0f);
        class_1087 model = GBModelLoadingPlugin.getBlockstateModel(element.modelId());
        if (model != null) {
            class_4588 buffer = this.field_59933.method_73477(class_4722.method_24074());
            int light = 0xF000F0;
            int overlay = class_4608.field_21444;
            for (class_10889 part : model.method_68512(mc.field_1687 != null ? mc.field_1687.field_9229 : class_5819.method_43047())) {
                for (class_2350 dir : class_2350.values()) {
                    for (class_777 quad : part.method_68509(dir)) {
                        buffer.method_22919(this.matrices.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
                    }
                }
                for (class_777 quad : part.method_68509(null)) {
                    buffer.method_22919(this.matrices.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
                }
            }
            this.field_59933.method_22993();
        }
        this.matrices.method_22909();
        texture.clear();
        guiState.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView()), element.method_72127(), element.comp_4122(), element.comp_4123(), element.comp_4124(), element.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
        TEXTURES.add(texture);
    }

    protected void render(BlockStateGuiElementRenderState state, class_4587 matrices) {
    }

    protected String method_70906() {
        return "blockstate gui renderer";
    }
}

