/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client;

import java.util.Optional;

import com.macuguita.backpacks.common.payload.OpenBackpackPayload;
import com.macuguita.backpacks.common.payload.OpenEquipmentPayload;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import org.lwjgl.glfw.GLFW;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;

public class GBKeybinds {

	public static void init() {
		class_304 openBackpackKey = KeyBindingHelper.registerKeyBinding(new class_304(
				"key.gbackpacks.open_backpack",
				class_3675.class_307.field_1668,
				GLFW.GLFW_KEY_B,
				"key.categories.gbackpacks"
		));
		Optional<class_304> maybeOpenEquipmentKey = Optional.empty();
		if (!EquipmentUtils.isTrinketsLoaded()) {
			maybeOpenEquipmentKey = Optional.of(KeyBindingHelper.registerKeyBinding(new class_304(
					"key.gbackpacks.open_equipment",
					class_3675.class_307.field_1668,
					GLFW.GLFW_KEY_G,
					"key.categories.gbackpacks"
			)));
		}
		Optional<class_304> finalMaybeOpenEquipmentKey = maybeOpenEquipmentKey;

		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			while (openBackpackKey.method_1436()) {
				OpenBackpackPayload.send();
				if (client.field_1724 != null && client.field_1687 != null) {
					int backpackSlot = EquipmentUtils.getBackpackSlotIndex(client.field_1724);
					if (backpackSlot != -1) {
						class_243 pos = client.field_1724.method_19538();
						client.field_1687.method_8486(
								pos.field_1352, pos.field_1351, pos.field_1350,
								class_3417.field_34376,
								class_3419.field_15248,
								1.0f,
								1.0f,
								false
						);
					}
				}
			}
			if (EquipmentUtils.isTrinketsLoaded()) return;
			finalMaybeOpenEquipmentKey.ifPresent(openEquipmentKey -> {
				while (openEquipmentKey.method_1436()) {
					OpenEquipmentPayload.send();
				}
			});
		});
	}
}
