/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client;

import java.util.ArrayList;
import java.util.List;

import com.macuguita.backpacks.client.gui.BackpackScreen;
import com.macuguita.backpacks.client.gui.EquipmentScreen;
import com.macuguita.backpacks.client.model.GBModelLoadingPlugin;
import com.macuguita.backpacks.client.payload.BackpackListSyncPayload;
import com.macuguita.backpacks.client.render.BackpackBlockEntityRenderer;
import com.macuguita.backpacks.client.render.BackpackFeatureRenderer;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.reg.GBBlockEntities;
import com.macuguita.backpacks.common.resourcereloader.BackpacksResourceReloadListener;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1007;
import net.minecraft.class_3929;
import net.minecraft.class_5616;

public class GuitaBackpacksClient implements ClientModInitializer {

	public static final List<BackpacksResourceReloadListener.Backpack> BACKPACKS = new ArrayList<>();

	@Override
	public void onInitializeClient() {

		GBKeybinds.init();

		class_5616.method_32144(GBBlockEntities.BACKPACK.get(), BackpackBlockEntityRenderer::new);

		ModelLoadingPlugin.register(new GBModelLoadingPlugin());
		LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
			if (entityRenderer instanceof class_1007 playerEntityRenderer) {
				registrationHelper.register(new BackpackFeatureRenderer<>(playerEntityRenderer));
			}
		});

		class_3929.method_17542(GuitaBackpacks.BACKPACK_SCREEN_HANDLER, BackpackScreen::new);
		if (!EquipmentUtils.isTrinketsLoaded())
			class_3929.method_17542(GuitaBackpacks.EQUIPMENT_SCREEN_HANDLER, EquipmentScreen::new);


		ClientPlayNetworking.registerGlobalReceiver(BackpackListSyncPayload.ID, (payload, context) -> {
			context.client().execute(() -> {
				BACKPACKS.clear();
				BACKPACKS.addAll(payload.list());
			});
		});
	}
}
