/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import com.macuguita.backpacks.common.block.BackpackBlock;
import com.macuguita.backpacks.common.block.entity.BackpackBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@SuppressWarnings("ClassCanBeRecord")
@Environment(EnvType.CLIENT)
public class BackpackBlockEntityRenderer implements class_827<BackpackBlockEntity> {

	private final class_5614.class_5615 context;

	public BackpackBlockEntityRenderer(class_5614.class_5615 context) {
		this.context = context;
	}

	@Override
	public void render(BackpackBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
		class_1087 model = context.method_43335().method_4012().method_3303().getModel(entity.getBlockModelId());
		class_2350 direction = entity.method_11010().method_11654(BackpackBlock.FACING);

		if (model == null) return;

		matrices.method_22903();

		// Move to block center
		matrices.method_22904(0.5, 0.5, 0.5);

		// Rotate according to block direction
		float rotation = switch (direction) {
			case field_11043 -> 0f;
			case field_11035 -> 180f;
			case field_11039  -> 90f;
			case field_11034  -> -90f;
			default    -> 0f;
		};
		matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));

		BakedModelRenderer.drawBakedModel(model, matrices, vertexConsumers, light, overlay);

		matrices.method_22909();
	}

}
