/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import com.macuguita.backpacks.common.reg.GBComponents;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_7833;

@Environment(EnvType.CLIENT)
public class BackpackFeatureRenderer<T extends class_1657, M extends class_591<T>> extends class_3887<T, M> {

	public BackpackFeatureRenderer(class_3883<T, M> context) {
		super(context);
	}

	// README: Item syncing is UNREALIABLE in CREATIVE mode do NOT try to fix it
	@Override
	public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {

		class_1799 chestStack = player.method_6118(class_1304.field_6174);
		if (chestStack.method_7909() == class_1802.field_8833)
			return;

		class_1799 backpack = EquipmentUtils.getEquippedBackpack(player);
		if (backpack.method_7960()) return;

		if (!backpack.method_57826(GBComponents.VISIBLE.get()) || !backpack.method_57826(GBComponents.BACKPACK_MODEL_ID.get()))
			return;

		if (Boolean.FALSE.equals(backpack.method_57824(GBComponents.VISIBLE.get())))
			return;

		class_1087 model = getModel(backpack.method_57824(GBComponents.BACKPACK_MODEL_ID.get()));
		matrices.method_22903();

		// Transforms the pose to player's body
		this.method_17165().field_3391.method_22703(matrices);

		// Apply transforms to fix rotation and inverted model
		matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
		matrices.method_22905(1.1F, -1.1F, -1.1F);
		int offset = !chestStack.method_7960() ? 3 : 2;
		matrices.method_22904(0, -0.06, offset * 0.0625);

		BakedModelRenderer.drawBakedModel(model, matrices, vertexConsumers, light, 0xF000F0);

		matrices.method_22909();
	}

	private class_1087 getModel(class_2960 id) {
		return class_310.method_1551().method_1480().method_4012().method_3303().getModel(id);
	}
}
