/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(EnvType.CLIENT)
public class BakedModelRenderer {

	private static final class_5819 RANDOM = class_5819.method_43047();

	public static void drawBakedModel(class_1087 model, class_4587 matrices, class_4597 vertexConsumer, int light, int overlay) {
		matrices.method_22903();
		matrices.method_46416(-0.5F, -0.5F, -0.5F);

		// Use a translucent block sheet for GUI-like rendering
		class_4588 consumer = vertexConsumer.getBuffer(class_4722.method_24076());

		// Render quads for each face
		for (class_2350 dir : class_2350.values()) {
			pushQuads(matrices, consumer, model.method_4707(null, dir, RANDOM), light, overlay);
		}

		// Render quads that are not face-specific
		pushQuads(matrices, consumer, model.method_4707(null, null, RANDOM), light, overlay);

		matrices.method_22909();
	}

	private static void pushQuads(class_4587 matrix, class_4588 consumer, List<class_777> quads, int light, int overlay) {
		class_4587.class_4665 last = matrix.method_23760();
		for (class_777 quad : quads) {
			consumer.method_22919(last, quad, 1f, 1f, 1f, 1f, light, overlay);
		}
	}
}
