/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.client.gui.payload.BackpackInventoryPayload;
import com.macuguita.backpacks.client.gui.slots.BackpackSlot;
import com.macuguita.backpacks.client.gui.slots.CustomSlot;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.macuguita.backpacks.common.reg.GBItemTags;
import com.macuguita.backpacks.common.utils.EquipmentUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class BackpackScreenHandler
extends class_1703 {
    private static final int VISIBLE_ROWS = 6;
    private static final int SLOT_SIZE = 18;
    private static final int GAP_BETWEEN_BACKPACK_AND_PLAYER = 13;
    private static final int TOP_PADDING = 14;
    private static final int SIDE_PADDING = 7;
    public final class_1263 inventory;
    public final class_1799 backpack;
    private final int totalRows;
    private final int backpackStartY;
    private final int playerInventoryStartY;
    private int scrollOffset = 0;

    public BackpackScreenHandler(int syncId, class_1661 playerInventory, BackpackInventoryPayload buf) {
        this(syncId, playerInventory, (class_1263)new class_1277(buf.backpackSize()), EquipmentUtils.getBackpackFromSlotIndex(playerInventory.field_7546, buf.slotIndex()));
    }

    public BackpackScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_1799 backpack) {
        super(GuitaBackpacks.BACKPACK_SCREEN_HANDLER, syncId);
        int col;
        BackpackScreenHandler.method_17359((class_1263)inventory, (int)inventory.method_5439());
        this.backpack = backpack;
        this.inventory = inventory;
        this.totalRows = (int)Math.ceil((double)inventory.method_5439() / 9.0);
        int visibleRows = Math.min(this.totalRows, 6);
        int backpackHeight = visibleRows * 18;
        this.backpackStartY = 14;
        this.playerInventoryStartY = this.backpackStartY + backpackHeight + 13;
        inventory.method_5435(playerInventory.field_7546);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.method_7621(new BackpackSlot(inventory, i, -1000, -1000, backpack, GBItemTags.BACKPACK_BLACKLIST));
        }
        this.updateSlotPositions();
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                this.method_7621(new BackpackSlot((class_1263)playerInventory, index, 7 + col * 18, this.playerInventoryStartY + row * 18, backpack));
            }
        }
        int hotbarY = this.playerInventoryStartY + 54 + 4;
        for (col = 0; col < 9; ++col) {
            this.method_7621(new BackpackSlot((class_1263)playerInventory, col, 7 + col * 18, hotbarY, backpack));
        }
    }

    public void scroll(int direction) {
        int maxScroll = Math.max(0, this.totalRows - 6);
        int oldOffset = this.scrollOffset;
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset + direction));
        if (oldOffset != this.scrollOffset) {
            this.updateSlotPositions();
        }
    }

    public void updateSlotPositions() {
        int i;
        int startIndex = this.scrollOffset * 9;
        int totalSlots = this.inventory.method_5439();
        int visibleSlots = Math.min(54, totalSlots - startIndex);
        for (i = 0; i < visibleSlots; ++i) {
            int slotIndex = startIndex + i;
            CustomSlot slot = (CustomSlot)this.field_7761.get(slotIndex);
            int row = i / 9;
            int col = i % 9;
            int x = 7 + col * 18;
            int y = this.backpackStartY + row * 18;
            slot.gbackpacks$setX(x);
            slot.gbackpacks$setY(y);
        }
        for (i = 0; i < totalSlots; ++i) {
            if (i >= startIndex && i < startIndex + visibleSlots) continue;
            CustomSlot slot = (CustomSlot)this.field_7761.get(i);
            slot.gbackpacks$setX(-1000);
            slot.gbackpacks$setY(-1000);
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getPlayerInventoryStartY() {
        return this.playerInventoryStartY;
    }

    public int getBackpackStartY() {
        return this.backpackStartY;
    }

    public boolean needsScrolling() {
        return this.totalRows > 6;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 originalStack = slot.method_7677();
        class_1799 newStack = originalStack.method_7972();
        int playerInvStartIndex = this.inventory.method_5439();
        int playerInvEndIndex = this.field_7761.size();
        boolean moved = invSlot < playerInvStartIndex ? this.method_7616(originalStack, playerInvStartIndex, playerInvEndIndex, true) : this.insertItemIntoBackpack(originalStack);
        if (!moved) {
            return class_1799.field_8037;
        }
        if (originalStack.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return newStack;
    }

    private boolean insertItemIntoBackpack(class_1799 stack) {
        class_1799 slotStack;
        int i;
        if (stack.method_31573(GBItemTags.BACKPACK_BLACKLIST)) {
            return false;
        }
        for (i = 0; i < this.inventory.method_5439(); ++i) {
            int combined;
            int transferred;
            slotStack = this.inventory.method_5438(i);
            if (slotStack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)slotStack) || (transferred = (combined = Math.min(stack.method_7947() + slotStack.method_7947(), slotStack.method_7914())) - slotStack.method_7947()) <= 0) continue;
            slotStack.method_7939(combined);
            stack.method_7934(transferred);
            if (!stack.method_7960()) continue;
            return true;
        }
        for (i = 0; i < this.inventory.method_5439(); ++i) {
            slotStack = this.inventory.method_5438(i);
            if (!slotStack.method_7960()) continue;
            this.inventory.method_5447(i, stack.method_7972());
            stack.method_7939(0);
            return true;
        }
        return false;
    }
}

