/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.common.resourcereloader;

import com.google.gson.JsonObject;
import com.macuguita.backpacks.common.GuitaBackpacks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5699;
import org.joml.Vector3f;

public class BackpacksResourceReloadListener
implements SimpleSynchronousResourceReloadListener {
    public static final List<Backpack> BACKPACKS = new ArrayList<Backpack>();
    private static final class_2960 ID = GuitaBackpacks.id("backpacks_resource_reload_listener");
    private static final class_2960 BACKPACKS_DIR = GuitaBackpacks.id("backpacks");

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        BACKPACKS.clear();
        Map resources = manager.method_14488(BACKPACKS_DIR.method_12832(), path -> path.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482());){
                JsonObject json = class_3518.method_15255((Reader)reader);
                DataResult result = Backpack.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                result.resultOrPartial(error -> GuitaBackpacks.LOGGER.warn("Failed to parse backpack at {}: {}", (Object)id, error)).ifPresent(BACKPACKS::add);
            }
            catch (Exception e) {
                GuitaBackpacks.LOGGER.error("Error reading backpack at {}: {}", new Object[]{id, e.getMessage(), e});
            }
        }
    }

    public record Backpack(class_2960 id, String translationKey, class_241 guiDisplacement, float guiScale, class_238 blockCollisionShape) {
        public static final Codec<class_241> VECTOR2F_CODEC = Codec.FLOAT.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)2).map(listf -> new class_241(((Float)listf.getFirst()).floatValue(), ((Float)listf.get(1)).floatValue())), vector2f -> List.of(Float.valueOf(vector2f.field_1343), Float.valueOf(vector2f.field_1342)));
        public static final Codec<class_238> BOX_CODEC = class_5699.field_40723.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)2).map(listv3f -> {
            Vector3f min = (Vector3f)listv3f.get(0);
            Vector3f max = (Vector3f)listv3f.get(1);
            return new class_238((double)min.x / 16.0, (double)min.y / 16.0, (double)min.z / 16.0, (double)max.x / 16.0, (double)max.y / 16.0, (double)max.z / 16.0);
        }), box -> List.of(new Vector3f((float)(box.field_1323 * 16.0), (float)(box.field_1322 * 16.0), (float)(box.field_1321 * 16.0)), new Vector3f((float)(box.field_1320 * 16.0), (float)(box.field_1325 * 16.0), (float)(box.field_1324 * 16.0))));
        public static final Codec<Backpack> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("id").forGetter(Backpack::id), (App)Codec.STRING.fieldOf("translation_key").forGetter(Backpack::translationKey), (App)VECTOR2F_CODEC.optionalFieldOf("gui_displacement", (Object)new class_241(0.0f, 0.0f)).forGetter(Backpack::guiDisplacement), (App)Codec.FLOAT.optionalFieldOf("gui_scale", (Object)Float.valueOf(1.0f)).flatXmap(scale -> scale.floatValue() > 0.0f ? DataResult.success((Object)scale) : DataResult.error(() -> "gui_scale must be higher than 0 " + scale), DataResult::success).forGetter(Backpack::guiScale), (App)BOX_CODEC.optionalFieldOf("block_collision_shape", (Object)new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)).forGetter(Backpack::blockCollisionShape)).apply((Applicative)i, Backpack::new));
    }
}

