/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.common.utils;

import com.macuguita.backpacks.common.components.EquipmentComponent;
import com.macuguita.backpacks.common.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.common.item.BackpackItem;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class EquipmentUtils {
    private static final int TRINKET_SLOT_OFFSET = 10000;
    private static final int CUSTOM_EQUIPMENT_SLOT_OFFSET = 20000;

    public static boolean isTrinketsLoaded() {
        return FabricLoader.getInstance().isModLoaded("trinkets");
    }

    public static class_1799 getEquippedBackpack(class_1657 player) {
        if (!EquipmentUtils.isTrinketsLoaded()) {
            return ((EquipmentComponent)GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get((Object)player)).getBackpack();
        }
        return TrinketsApi.getTrinketComponent((class_1309)player).map(component -> component.getEquipped(stack -> stack.method_7909() instanceof BackpackItem).stream().findFirst().map(class_3545::method_15441).orElse(class_1799.field_8037)).orElse(class_1799.field_8037);
    }

    public static int getBackpackSlotIndex(class_1657 player) {
        if (EquipmentUtils.isTrinketsLoaded()) {
            return EquipmentUtils.getTrinketBackpackSlotIndex(player);
        }
        class_1799 customBackpack = ((EquipmentComponent)GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get((Object)player)).getBackpack();
        if (!customBackpack.method_7960() && customBackpack.method_7909() instanceof BackpackItem) {
            return 20000;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof BackpackItem)) continue;
            return i;
        }
        return -1;
    }

    private static int getTrinketBackpackSlotIndex(class_1657 player) {
        TrinketComponent trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        if (trinketComponent == null) {
            return -1;
        }
        int groupIndex = 0;
        for (Map.Entry groupEntry : trinketComponent.getGroups().entrySet()) {
            String groupId = (String)groupEntry.getKey();
            int slotTypeIndex = 0;
            for (Map.Entry slotEntry : ((SlotGroup)groupEntry.getValue()).getSlots().entrySet()) {
                String slotId = (String)slotEntry.getKey();
                TrinketInventory trinketInv = (TrinketInventory)((Map)trinketComponent.getInventory().get(groupId)).get(slotId);
                for (int i = 0; i < trinketInv.method_5439(); ++i) {
                    class_1799 stack = trinketInv.method_5438(i);
                    if (!(stack.method_7909() instanceof BackpackItem)) continue;
                    return 10000 + groupIndex * 1000 + slotTypeIndex * 100 + i;
                }
                ++slotTypeIndex;
            }
            ++groupIndex;
        }
        return -1;
    }

    public static class_1799 getBackpackFromSlotIndex(class_1657 player, int slotIndex) {
        if (slotIndex < 0) {
            return class_1799.field_8037;
        }
        if (slotIndex >= 20000) {
            return ((EquipmentComponent)GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get((Object)player)).getBackpack();
        }
        if (slotIndex >= 10000) {
            if (EquipmentUtils.isTrinketsLoaded()) {
                return EquipmentUtils.getBackpackFromTrinketSlotIndex(player, slotIndex);
            }
            return class_1799.field_8037;
        }
        if (slotIndex < player.method_31548().method_5439()) {
            return player.method_31548().method_5438(slotIndex);
        }
        return class_1799.field_8037;
    }

    private static class_1799 getBackpackFromTrinketSlotIndex(class_1657 player, int slotIndex) {
        TrinketComponent trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        if (trinketComponent == null) {
            return class_1799.field_8037;
        }
        int encoded = slotIndex - 10000;
        int targetGroupIndex = encoded / 1000;
        int targetSlotTypeIndex = encoded % 1000 / 100;
        int targetSlot = encoded % 100;
        int groupIndex = 0;
        for (Map.Entry groupEntry : trinketComponent.getGroups().entrySet()) {
            if (groupIndex == targetGroupIndex) {
                String groupId = (String)groupEntry.getKey();
                int slotTypeIndex = 0;
                for (Map.Entry slotEntry : ((SlotGroup)groupEntry.getValue()).getSlots().entrySet()) {
                    if (slotTypeIndex == targetSlotTypeIndex) {
                        String slotId = (String)slotEntry.getKey();
                        TrinketInventory trinketInv = (TrinketInventory)((Map)trinketComponent.getInventory().get(groupId)).get(slotId);
                        if (targetSlot < trinketInv.method_5439()) {
                            return trinketInv.method_5438(targetSlot);
                        }
                        return class_1799.field_8037;
                    }
                    ++slotTypeIndex;
                }
            }
            ++groupIndex;
        }
        return class_1799.field_8037;
    }
}

