/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.GuitaBackpacks;
import com.macuguita.backpacks.client.GuitaBackpacksClient;
import com.macuguita.backpacks.client.gui.widgets.ScrollBarWidget;
import com.macuguita.backpacks.client.render.state.BlockStateGuiElementRenderState;
import com.macuguita.backpacks.network.BackpacksResourceReloadListener;
import com.macuguita.backpacks.network.payload.BackpackCosmeticSyncPayload;
import com.macuguita.backpacks.reg.GBComponents;
import org.joml.Matrix3x2f;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8030;

@Environment(EnvType.CLIENT)
public class BackpackCustomizationScreen extends class_437 {

	public static final class_2960 BACKGROUND_TEXTURE = GuitaBackpacks.id("background");

	private static final int BACKGROUND_WIDTH = 176;
	private static final int BACKGROUND_HEIGHT = 166;
	private static final int ITEM_LIST_GAP = 2;
	private static final int DEFAULT_ITEM_TEXT_COLOR = 0xFFCCCCCC;
	private static final int SELECTED_ITEM_TEXT_COLOR = 0xFFFFFFFF;
	private static final int HOVERED_ITEM_TEXT_COLOR = 0xFFE6E6E6;
	private static final int ITEM_WIDTH = 133;
	private static final int ITEM_HEIGHT = 24;

	final class_1799 backpack;
	private final class_2960 currentModelId;
	public final class_437 parent;
	private class_2960 selectedModelId;
	private int scrollOffset = 0;
	private ScrollBarWidget scrollBar;

	public BackpackCustomizationScreen(class_2561 title, class_437 parent, class_1799 backpack) {
		super(title);
		this.parent = parent;
		this.backpack = backpack;
		this.currentModelId = backpack.method_58694(GBComponents.BACKPACK_MODEL_ID.get());
		this.selectedModelId = this.currentModelId;
	}

	public static void drawModelInGui(class_332 context, class_2960 modelId, int x, int y, float scale) {
		int size = 27;

		float centerX = x + size / 2f;
		float centerY = y + size / 2f;

		Matrix3x2f pose = new Matrix3x2f()
				.translate(centerX, centerY)
				.scale(scale)
				.translate(-centerX, -centerY);

		class_8030 rect = new class_8030(x, y, size, size).method_71523(pose);

		BlockStateGuiElementRenderState renderState = new BlockStateGuiElementRenderState(
				pose,
				modelId,
				x,
				y,
				rect
		);

		context.field_59826.method_70922(renderState);
	}

	@Override
	protected void method_25426() {
		super.method_25426();

		int i = (this.field_22789 - BACKGROUND_WIDTH) / 2;
		int j = (this.field_22790 - BACKGROUND_HEIGHT) / 2;

		int scrollBarX = i + BACKGROUND_WIDTH - ScrollBarWidget.BACKGROUND_WIDTH - 10;
		int scrollBarY = j + 10;
		this.scrollBar = this.method_37063(
				new ScrollBarWidget(scrollBarX, scrollBarY, BACKGROUND_HEIGHT - 45, new ScrollBarWidget.ScrollCallback() {
					@Override
					public void onScroll(int delta) {
						scrollOffset += delta * 10;
						scrollOffset = Math.max(0, Math.min(scrollOffset, getMaxScrollOffset()));
					}

					@Override
					public void scrollTo(int offset) {
						scrollOffset = Math.max(0, Math.min(offset, getMaxScrollOffset()));
					}

					@Override
					public int getMaxScrollOffset() {
						return Math.max(0, GuitaBackpacksClient.BACKPACKS.size() * (ITEM_HEIGHT + ITEM_LIST_GAP) - (scrollBar.method_25364() - 30));
					}

					@Override
					public int getCurrentScrollOffset() {
						return scrollOffset;
					}

					@Override
					public boolean canScroll() {
						return getMaxScrollOffset() > 0;
					}
				})
		);

		this.method_37063(
				class_4185.method_46430(class_2561.method_43471("gui.done"), button -> {
							if (!this.selectedModelId.equals(this.currentModelId)) {
								ClientPlayNetworking.send(new BackpackCosmeticSyncPayload(backpack, this.selectedModelId));
							}
							this.method_25419();
						})
						.method_46434(i + 10, j + BACKGROUND_HEIGHT - 30, BACKGROUND_WIDTH - 20, 20)
						.method_46431()
		);
	}

	@Override
	public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_25420(context, mouseX, mouseY, delta);
		int i = (this.field_22789 - BACKGROUND_WIDTH) / 2;
		int j = (this.field_22790 - BACKGROUND_HEIGHT) / 2;

		context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, i, j, BACKGROUND_WIDTH, BACKGROUND_HEIGHT);

		int listBgX = i + 10;
		int listBgY = j + 10;
		int listBgWidth = BACKGROUND_WIDTH - ScrollBarWidget.BACKGROUND_WIDTH - 23;
		int listBgHeight = scrollBar.method_25364();
		context.method_25294(listBgX, listBgY, listBgX + listBgWidth, listBgY + listBgHeight, 0xFF373737);

		context.method_44379(listBgX, listBgY, listBgX + listBgWidth, listBgY + listBgHeight);

		int padding = 2;
		int slotWidth = listBgWidth - (padding * 2);
		int startX = listBgX + padding;
		int startY = listBgY + padding;

		for (int index = 0; index < GuitaBackpacksClient.BACKPACKS.size(); index++) {
			BackpacksResourceReloadListener.Backpack backpackItem = GuitaBackpacksClient.BACKPACKS.get(index);
			int y = startY + index * (ITEM_HEIGHT + ITEM_LIST_GAP) - scrollOffset;

			if (y + ITEM_HEIGHT < listBgY || y > listBgY + listBgHeight) continue;

			boolean isSelected = backpackItem.id().equals(this.selectedModelId);
			boolean isHovered = mouseX >= startX && mouseX <= startX + slotWidth &&
					mouseY >= y && mouseY <= y + ITEM_HEIGHT;

			int bgColor = isSelected ? 0xFF4A90E2 :
					isHovered ? 0xFF5A5A5A :
							0xFF454545;
			context.method_25294(startX, y, startX + slotWidth, y + ITEM_HEIGHT, bgColor);

			if (isSelected) {
				context.method_25294(startX, y, startX + slotWidth, y + 1, 0xFF6AB0FF);
				context.method_25294(startX, y + ITEM_HEIGHT - 1, startX + slotWidth, y + ITEM_HEIGHT, 0xFF2A70C2);
			}

			int modelX = startX + backpackItem.guiDisplacement().x;
			int modelY = y + backpackItem.guiDisplacement().y - 2;

			drawModelInGui(context, backpackItem.id(), modelX,
					modelY, backpackItem.guiScale());

			int textColor = isSelected ? SELECTED_ITEM_TEXT_COLOR :
					isHovered ? HOVERED_ITEM_TEXT_COLOR :
							DEFAULT_ITEM_TEXT_COLOR;

			context.method_51439(this.field_22793, class_2561.method_43471(backpackItem.translationKey()),
					startX + 28, y + 8, textColor, isSelected);
		}

		context.method_44380();
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (scrollBar != null && scrollBar.getCallback().canScroll()) {
			int scrollDirection = verticalAmount > 0 ? -1 : 1;
			scrollOffset += scrollDirection * 10;
			scrollOffset = Math.max(0, Math.min(scrollOffset, scrollBar.getCallback().getMaxScrollOffset()));
			scrollBar.updateScrollPercent();
			return true;
		}
		return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
	}

	@Override
	public boolean method_25402(class_11909 click, boolean doubled) {
		int i = (this.field_22789 - BACKGROUND_WIDTH) / 2;
		int j = (this.field_22790 - BACKGROUND_HEIGHT) / 2;

		int startX = i + 12;
		int startY = j + 7;
		int listHeight = scrollBar.method_25364() - 30;

		for (int index = 0; index < GuitaBackpacksClient.BACKPACKS.size(); index++) {
			int y = startY + index * (ITEM_HEIGHT + ITEM_LIST_GAP) - scrollOffset;

			if (click.comp_4798() >= startX && click.comp_4798() <= startX + ITEM_WIDTH &&
					click.comp_4799() >= y && click.comp_4799() <= y + ITEM_HEIGHT &&
					y >= j + 5 && y + ITEM_HEIGHT <= j + 5 + listHeight) {
				BackpacksResourceReloadListener.Backpack clicked = GuitaBackpacksClient.BACKPACKS.get(index);

				this.selectedModelId = clicked.id();
				this.scrollBar.updateScrollPercent();
				return true;
			}
		}

		return super.method_25402(click, doubled);
	}

	@Override
	public boolean method_25421() {
		return false;
	}

	@Override
	public void method_25419() {
		if (this.field_22787 == null) return;
		this.field_22787.method_1507(this.parent);
	}
}
