/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.gui;

import com.macuguita.backpacks.GuitaBackpacks;
import com.macuguita.backpacks.client.gui.slots.BackpackSlot;
import com.macuguita.backpacks.item.BackpackItem;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class EquipmentScreenHandler extends class_1703 {

	private final class_1263 inventory;

	public EquipmentScreenHandler(int syncId, class_1661 playerInventory) {
		this(syncId, playerInventory, new class_1277(1));
	}

	public EquipmentScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
		super(GuitaBackpacks.EQUIPMENT_SCREEN_HANDLER, syncId);
		method_17359(inventory, 1);
		this.inventory = inventory;
		inventory.method_5435(playerInventory.field_7546);

		int m;
		int l;
		this.method_7621(new BackpackSlot(inventory, 0, 80, 43, stack -> stack.method_7909() instanceof BackpackItem));

		for (m = 0; m < 3; ++m) {
			for (l = 0; l < 9; ++l) {
				this.method_7621(new class_1735(playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
			}
		}
		for (m = 0; m < 9; ++m) {
			this.method_7621(new class_1735(playerInventory, m, 8 + m * 18, 142));
		}
	}

	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 newStack = class_1799.field_8037;
		class_1735 sourceSlot = this.field_7761.get(index);

		if (sourceSlot.method_7681()) {
			class_1799 originalStack = sourceSlot.method_7677();
			newStack = originalStack.method_7972();

			int containerSlotCount = this.inventory.method_5439();

			if (index < containerSlotCount) {
				if (!this.method_7616(originalStack, containerSlotCount, this.field_7761.size(), true)) {
					return class_1799.field_8037;
				}
			} else {
				if (!this.method_7616(originalStack, 0, containerSlotCount, false)) {
					return class_1799.field_8037;
				}
			}

			if (originalStack.method_7960()) {
				sourceSlot.method_53512(class_1799.field_8037);
			} else {
				sourceSlot.method_7668();
			}
		}

		return newStack;
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
}
