/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render;

import com.macuguita.backpacks.block.entity.BackpackBlockEntity;
import com.macuguita.backpacks.client.model.GBModelLoadingPlugin;
import com.macuguita.backpacks.client.render.state.BackpackBlockEntityRenderState;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3715;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@SuppressWarnings("ClassCanBeRecord")
@Environment(EnvType.CLIENT)
public class BackpackBlockEntityRenderer implements class_827<BackpackBlockEntity, BackpackBlockEntityRenderState> {

	private final class_5614.class_5615 context;

	public BackpackBlockEntityRenderer(class_5614.class_5615 context) {
		this.context = context;
	}

	@Override
	public void updateRenderState(BackpackBlockEntity blockEntity, BackpackBlockEntityRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
		class_827.super.method_74331(blockEntity, state, tickProgress, cameraPos, crumblingOverlay);
		state.modelId = blockEntity.getBlockModelId();
		state.direction = blockEntity.method_11010().method_11654(class_3715.field_16404);
	}

	@Override
	public BackpackBlockEntityRenderState method_74335() {
		return new BackpackBlockEntityRenderState();
	}

	@Override
	public void render(BackpackBlockEntityRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
		class_1087 model = GBModelLoadingPlugin.getBlockstateModel(state.modelId);
		class_2350 direction = state.direction;

		if (model == null)
			return;

		matrices.method_22903();

		matrices.method_22904(0.5, 0.5, 0.5);

		// Rotate according to block direction
		float rotation = switch (direction) {
			case field_11043 -> 0f;
			case field_11035 -> 180f;
			case field_11039  -> 90f;
			case field_11034  -> -90f;
			default    -> 0f;
		};

		matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));

		matrices.method_22904(-0.5, -0.5, -0.5);

		queue.method_73529(0).method_73484(
				matrices,
				class_4722.method_24074(),
				model,
				1, 1, 1,
				state.field_62676,
				class_4608.field_21444,
				0
		);
		matrices.method_22909();
	}
}
