/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.client.render.state;

import com.macuguita.backpacks.block.BackpackBlock;
import com.macuguita.backpacks.block.entity.BackpackBlockEntity;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_11954;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class BackpackBlockEntityRenderState extends class_11954 {

	public static final RenderStateDataKey<BackpackBlockEntityRenderState> KEY = RenderStateDataKey.create(() -> "backpack_block");

	public class_2960 modelId = null;
	public class_2350 direction = class_2350.field_11043;

	public static <E extends class_2586, S extends class_11954> void updateRenderState(E blockEntity, S state) {
		BackpackBlockEntityRenderState backpackRenderState = new BackpackBlockEntityRenderState();
		if (!(blockEntity instanceof BackpackBlockEntity backpackBlock))
			return;
		backpackRenderState.direction = blockEntity.method_11010().method_11654(BackpackBlock.FACING);
		backpackRenderState.modelId = backpackBlock.getBlockModelId();
		state.setData(KEY, backpackRenderState);
	}
}
