/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.components;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class EquipmentComponent implements Component, AutoSyncedComponent {

	private final class_1657 player;
	private final class_1277 inventory = new class_1277(1) {
		@Override
		public void method_5431() {
			super.method_5431();
			if (!player.method_73183().method_8608()) {
				GuitaBackpacksComponents.EQUIPMENT_COMPONENT.sync(player);
			}
		}
	};

	public EquipmentComponent(class_1657 player) {
		this.player = player;
	}

	public void clearInventory() {
		inventory.method_5448();
		GuitaBackpacksComponents.EQUIPMENT_COMPONENT.sync(player);
	}

	public class_1277 getInventory() {
		return inventory;
	}

	public class_1799 getBackpack() {

		return inventory.method_5438(0);
	}

	@Override
	public void readData(class_11368 readView) {
		this.inventory.method_5448();
		class_1262.method_5429(readView, this.inventory.field_5828);
	}

	@Override
	public void writeData(class_11372 writeView) {
		class_1262.method_5426(writeView, this.inventory.field_5828);
	}
}
