/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.datagen;

import java.util.concurrent.CompletableFuture;

import com.macuguita.backpacks.reg.GBItemTags;
import com.macuguita.backpacks.reg.GBObjects;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_7225;

public class GBItemTagProvider extends FabricTagProvider.ItemTagProvider {

	public GBItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
		super(output, completableFuture);
	}

	@Override
	protected void method_10514(class_7225.class_7874 wrapperLookup) {
		valueLookupBuilder(GBItemTags.BACKPACK_BLACKLIST)
				.method_71554(GBObjects.BACKPACK.get())
				.forceAddTag(ConventionalItemTags.SHULKER_BOXES);
		valueLookupBuilder(GBItemTags.TRINKETS_CHEST)
				.method_71554(GBObjects.BACKPACK.get());
	}
}
