/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.datagen;

import java.util.concurrent.CompletableFuture;

import com.macuguita.backpacks.reg.GBObjects;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

public class GBRecipeProvider extends FabricRecipeProvider {

	public GBRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
		super(output, registriesFuture);
	}

	@Override
	protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 recipeExporter) {
		return new class_2446(wrapperLookup, recipeExporter) {

			@Override
			public void method_10419() {
				class_2447.method_10436(class_7923.field_41178, class_7800.field_40638, GBObjects.BACKPACK.get(), 1)
						.method_10439(" # ")
						.method_10439("#$#")
						.method_10439(" # ")
						.method_10434('#', class_1802.field_8745)
						.method_10434('$', class_1802.field_8106)
						.method_10429(method_32807(class_1802.field_8745), method_10426(class_1802.field_8745))
						.method_10429(method_32807(class_1802.field_8106), method_10426(class_1802.field_8106))
						.method_10431(recipeExporter);
			}
		};
	}

	@Override
	public String method_10321() {
		return "guita's Backpacks";
	}
}
