/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.reg;

import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import com.macuguita.backpacks.GuitaBackpacks;
import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import com.mojang.serialization.Codec;

public class GBComponents {

	static final GuitaRegistry<class_9331<?>> COMPONENTS = GuitaRegistries.create(class_7923.field_49658, GuitaBackpacks.MOD_ID);

	public static final GuitaRegistryEntry<class_9331<UUID>> BACKPACK_UUID = COMPONENTS.register("backpack_uuid",
			() -> class_9331.<UUID>method_57873().method_57881(class_4844.field_40825).method_57880());

	public static final GuitaRegistryEntry<class_9331<Boolean>> VISIBLE = COMPONENTS.register("visible",
			() -> class_9331.<Boolean>method_57873().method_57881(Codec.BOOL).method_57880());

	public static final GuitaRegistryEntry<class_9331<class_2960>> BACKPACK_MODEL_ID = COMPONENTS.register("backpack_model",
			() -> class_9331.<class_2960>method_57873().method_57881(class_2960.field_25139).method_57880());

	public static void init() {
		COMPONENTS.init();
	}
}
