/*
 * Copyright (c) 2025 macuguita
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.macuguita.backpacks.reg;

import com.macuguita.backpacks.GuitaBackpacks;
import com.macuguita.lib.platform.registry.GuitaRegistries;
import com.macuguita.lib.platform.registry.GuitaRegistry;
import com.macuguita.lib.platform.registry.GuitaRegistryEntry;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public class GBItemGroups {

	static final GuitaRegistry<class_1761> ITEM_GROUPS = GuitaRegistries.create(class_7923.field_44687, GuitaBackpacks.MOD_ID);

	public static final GuitaRegistryEntry<class_1761> GW_TAB = ITEM_GROUPS.register("gbackpacks", () ->
			class_1761.method_47307(class_1761.class_7915.field_41049, 0)
					.method_47321(class_2561.method_43471("itemGroup." + GuitaBackpacks.MOD_ID + ".gbackpacks"))
					.method_47320(() -> new class_1799(GBObjects.BACKPACK.get().method_8389()))
					.method_47317((itemDisplayParameters, output) ->
							GBObjects.ITEMS.stream().map(item -> item.get().method_7854()).forEach(output::method_45420)
					).method_47324());

	public static void init() {
		ITEM_GROUPS.init();
	}
}
