/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks;

import com.macuguita.backpacks.client.gui.BackpackScreenHandler;
import com.macuguita.backpacks.client.gui.EquipmentScreenHandler;
import com.macuguita.backpacks.compat.TrinketsCompat;
import com.macuguita.backpacks.components.EquipmentComponent;
import com.macuguita.backpacks.components.GuitaBackpacksComponents;
import com.macuguita.backpacks.config.GBConfig;
import com.macuguita.backpacks.item.BackpackItem;
import com.macuguita.backpacks.network.BackpackCosmeticSyncPayload;
import com.macuguita.backpacks.network.BackpackInventoryPayload;
import com.macuguita.backpacks.network.BackpackListSyncPayload;
import com.macuguita.backpacks.network.BackpacksResourceReloadListener;
import com.macuguita.backpacks.network.OpenBackpackPayload;
import com.macuguita.backpacks.network.OpenEquipmentPayload;
import com.macuguita.backpacks.reg.GBBlockEntities;
import com.macuguita.backpacks.reg.GBComponents;
import com.macuguita.backpacks.reg.GBItemGroups;
import com.macuguita.backpacks.reg.GBObjects;
import com.macuguita.backpacks.utils.BackpackUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuitaBackpacks
implements ModInitializer {
    public static final String MOD_ID = "gbackpacks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gbackpacks");
    public static final class_2960 BACKPACK_INVENTORY_SIZE_PACKET = GuitaBackpacks.id("backpack_inventory_size");
    public static final class_2960 OPEN_BACKPACK_PACKET = GuitaBackpacks.id("open_backpack");
    public static final class_2960 OPEN_EQUIPMENT_PACKET = GuitaBackpacks.id("open_equipment");
    public static final class_2960 BACKPACK_LIST_SYNC = GuitaBackpacks.id("backpack_list_sync");
    public static final class_2960 BACKPACK_COSMETIC_SYNC = GuitaBackpacks.id("backpack_cosmetic_sync");
    public static final class_2960 DEFAULT_BACKPACK_MODEL_ID = GuitaBackpacks.id("backpacks/backpack");
    public static final ExtendedScreenHandlerType<BackpackScreenHandler, BackpackInventoryPayload> BACKPACK_SCREEN_HANDLER = new ExtendedScreenHandlerType(BackpackScreenHandler::new, BackpackInventoryPayload.CODEC);
    public static final class_3917<EquipmentScreenHandler> EQUIPMENT_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)GuitaBackpacks.id("equipment"), (Object)new class_3917(EquipmentScreenHandler::new, class_7699.method_45397()));

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(BackpackInventoryPayload.ID, BackpackInventoryPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(BackpackListSyncPayload.ID, BackpackListSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenBackpackPayload.ID, OpenBackpackPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenEquipmentPayload.ID, OpenEquipmentPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BackpackCosmeticSyncPayload.ID, BackpackCosmeticSyncPayload.CODEC);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)GuitaBackpacks.id("backpack"), BACKPACK_SCREEN_HANDLER);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new BackpacksResourceReloadListener());
        GBConfig.load();
        GBComponents.init();
        GBObjects.init();
        GBBlockEntities.init();
        GBItemGroups.init();
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1542)) {
                return;
            }
            class_1542 itemEntity = (class_1542)entity;
            class_1799 stack = itemEntity.method_6983();
            if (!stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) {
                return;
            }
            BackpackUtils.dedupeBackpackItemEntity(itemEntity);
        });
        ServerPlayNetworking.registerGlobalReceiver(OpenBackpackPayload.ID, (payload, context) -> {
            if (payload.buf()) {
                context.server().execute(() -> {
                    class_3222 player = context.player();
                    class_1799 backpack = TrinketsCompat.getEquippedBackpack((class_1657)player);
                    if (!backpack.method_7960()) {
                        BackpackItem.openOrCreateBackpackIfNotExists(backpack, (class_1657)player);
                        return;
                    }
                    if (!player.method_31548().method_5442()) {
                        class_2371 inventory = player.method_31548().field_7547;
                        for (class_1799 stack : inventory) {
                            if (!stack.method_31574((class_1792)GBObjects.BACKPACK.get()) || !stack.method_57826((class_9331)GBComponents.BACKPACK_UUID.get())) continue;
                            BackpackItem.openOrCreateBackpackIfNotExists(stack, (class_1657)player);
                            return;
                        }
                    }
                });
            }
        });
        if (!TrinketsCompat.isTrinketsLoaded()) {
            ServerPlayNetworking.registerGlobalReceiver(OpenEquipmentPayload.ID, (payload, context) -> {
                if (payload.buf()) {
                    context.server().execute(() -> {
                        class_3222 player = context.player();
                        class_3908 factory = new class_3908(this){

                            public class_2561 method_5476() {
                                return class_2561.method_43473();
                            }

                            @Nullable
                            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                                return new EquipmentScreenHandler(syncId, playerInventory, (class_1263)((EquipmentComponent)GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get((Object)player)).getInventory());
                            }
                        };
                        player.method_17355(factory);
                    });
                }
            });
        }
        ServerPlayNetworking.registerGlobalReceiver(BackpackCosmeticSyncPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            int slot = player.method_31548().method_7395(payload.oldBackpack());
            if (slot >= 0) {
                class_1799 backpack = player.method_31548().method_5438(slot);
                if (!backpack.method_57826((class_9331)GBComponents.BACKPACK_MODEL_ID.get())) {
                    return;
                }
                backpack.method_57379((class_9331)GBComponents.BACKPACK_MODEL_ID.get(), (Object)payload.newId());
            } else {
                class_1799 backpack = TrinketsCompat.getEquippedBackpack((class_1657)player);
                if (!backpack.method_57826((class_9331)GBComponents.BACKPACK_MODEL_ID.get())) {
                    return;
                }
                backpack.method_57379((class_9331)GBComponents.BACKPACK_MODEL_ID.get(), (Object)payload.newId());
                if (!TrinketsCompat.isTrinketsLoaded()) {
                    ((EquipmentComponent)GuitaBackpacksComponents.EQUIPMENT_COMPONENT.get((Object)player)).getInventory().method_5431();
                }
            }
        }));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_8710)new BackpackListSyncPayload(BackpacksResourceReloadListener.BACKPACKS)));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> {
            if (success) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new BackpackListSyncPayload(BackpacksResourceReloadListener.BACKPACKS));
                }
            }
        });
    }
}

