/*
 * Decompiled with CFR 0.152.
 */
package com.macuguita.backpacks.components;

import com.macuguita.backpacks.config.GBConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;

public class BackpacksComponent
implements Component {
    private final Map<UUID, class_1277> backpacks = new HashMap<UUID, class_1277>();

    public BackpacksComponent(class_269 provider, @Nullable MinecraftServer server) {
    }

    public void removeBackpack(UUID uuid) {
        this.backpacks.remove(uuid);
    }

    public void addInventory(UUID uuid) {
        assert (GBConfig.getDefaultBackpackSize() != null);
        if (uuid == null) {
            return;
        }
        this.addInventory(uuid, GBConfig.getDefaultBackpackSize());
    }

    public void addInventory(UUID uuid, int size) {
        if (uuid == null) {
            return;
        }
        this.backpacks.put(uuid, new class_1277(size));
    }

    public class_1277 getInventory(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return this.backpacks.get(uuid);
    }

    public boolean growBackpack(UUID uuid, int newSize) {
        if (uuid == null) {
            return false;
        }
        class_1277 oldInventory = this.backpacks.get(uuid);
        if (oldInventory != null) {
            int oldSize = oldInventory.method_5439();
            if (newSize <= oldSize) {
                return false;
            }
            class_1277 newInventory = new class_1277(newSize);
            for (int i = 0; i < oldSize; ++i) {
                newInventory.method_5447(i, oldInventory.method_5438(i));
            }
            this.backpacks.put(uuid, newInventory);
            return true;
        }
        return false;
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.backpacks.clear();
        class_2499 backpacksNbtList = nbtCompound.method_10554("Backpacks", 10);
        for (int i = 0; i < backpacksNbtList.size(); ++i) {
            class_2487 backpackTag = backpacksNbtList.method_10602(i);
            UUID uuid = backpackTag.method_25926("UUID");
            int size = backpackTag.method_10550("Size");
            class_1277 inventory = new class_1277(size);
            class_1262.method_5429((class_2487)backpackTag, (class_2371)inventory.field_5828, (class_7225.class_7874)wrapperLookup);
            this.backpacks.put(uuid, inventory);
        }
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        class_2499 backpacksNbtList = new class_2499();
        for (Map.Entry<UUID, class_1277> entry : this.backpacks.entrySet()) {
            UUID uuid = entry.getKey();
            class_1277 inventory = entry.getValue();
            class_2487 backpackTag = new class_2487();
            backpackTag.method_25927("UUID", uuid);
            backpackTag.method_10569("Size", inventory.method_5439());
            class_1262.method_5426((class_2487)backpackTag, (class_2371)inventory.field_5828, (class_7225.class_7874)wrapperLookup);
            backpacksNbtList.add((Object)backpackTag);
        }
        nbtCompound.method_10566("Backpacks", (class_2520)backpacksNbtList);
    }
}

