/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jn.willfrydev.xjumpads.manager.DirectionType;
import jn.willfrydev.xjumpads.manager.JumpPad;
import jn.willfrydev.xjumpads.manager.JumpPadManager;
import jn.willfrydev.xjumpads.utils.ColorUtils;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final xJumPads plugin;
    private final JumpPadManager jumpPadManager;
    private final String prefix;

    public CommandManager(xJumPads plugin) {
        this.plugin = plugin;
        this.jumpPadManager = plugin.getJumpPadManager();
        this.prefix = plugin.getMessagesFile().getConfig().getString("prefix");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender, args);
                break;
            }
            case "menu": {
                this.handleMenu(sender);
                break;
            }
            default: {
                this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("usage.main"));
            }
        }
        return true;
    }

    private void handleMenu(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("player-only"));
            return;
        }
        String menuPerm = this.plugin.getConfig().getString("permissions.admin.menu", "xjumppads.admin.menu");
        if (!sender.hasPermission(menuPerm)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("no-permission"));
            return;
        }
        this.plugin.getGuiManager().openJumpPadMenu((Player)sender);
    }

    private void handleReload(CommandSender sender) {
        String reloadPerm = this.plugin.getConfig().getString("permissions.admin.reload", "xjumppads.admin.reload");
        if (!sender.hasPermission(reloadPerm)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("no-permission"));
            return;
        }
        this.plugin.reloadConfig();
        this.plugin.getMessagesFile().reload();
        this.jumpPadManager.loadJumpPads();
        this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("reload"));
    }

    private void handleList(CommandSender sender) {
        String listPerm = this.plugin.getConfig().getString("permissions.admin.list", "xjumppads.list");
        if (!sender.hasPermission(listPerm)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("no-permission"));
            return;
        }
        if (this.jumpPadManager.getAllJumpPads().isEmpty()) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("jumppad.list-empty"));
            return;
        }
        this.plugin.getMessagesFile().getConfig().getStringList("jumppad.list-header").forEach(line -> sender.sendMessage(ColorUtils.colorize(line)));
        String format = this.plugin.getMessagesFile().getConfig().getString("jumppad.list-format");
        for (JumpPad pad : this.jumpPadManager.getAllJumpPads()) {
            String message = format.replace("%name%", pad.getName()).replace("%x%", String.valueOf(pad.getLocation().getBlockX())).replace("%y%", String.valueOf(pad.getLocation().getBlockY())).replace("%z%", String.valueOf(pad.getLocation().getBlockZ()));
            sender.sendMessage(ColorUtils.colorize(message));
        }
    }

    private void handleSet(CommandSender sender, String[] args) {
        DirectionType directionType;
        double power;
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("player-only"));
            return;
        }
        String setPerm = this.plugin.getConfig().getString("permissions.admin.set", "xjumppads.admin.set");
        if (!sender.hasPermission(setPerm)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("no-permission"));
            return;
        }
        if (args.length < 4) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("usage.set"));
            return;
        }
        Player player = (Player)sender;
        String name = args[1];
        try {
            power = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, "&cLa potencia debe ser un n\u00famero.");
            return;
        }
        try {
            directionType = DirectionType.valueOf(args[3].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.sendMessage(sender, "&cLa direcci\u00f3n no es v\u00e1lida. Opciones: forward, up, custom.");
            return;
        }
        double angle = 0.0;
        if (directionType == DirectionType.CUSTOM) {
            if (args.length != 5) {
                this.sendMessage(sender, "&cUso: /jp set <nombre> <potencia> custom <\u00e1ngulo>");
                return;
            }
            try {
                angle = Double.parseDouble(args[4]);
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, "&cEl \u00e1ngulo debe ser un n\u00famero.");
                return;
            }
        }
        if (this.jumpPadManager.getJumpPad(name) != null) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("jumppad.already-exists").replace("%name%", name));
            return;
        }
        this.jumpPadManager.createJumpPad(name, player.getLocation().getBlock().getLocation(), power, directionType, angle, (CommandSender)player);
        this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("jumppad.created").replace("%name%", name));
    }

    private void handleRemove(CommandSender sender, String[] args) {
        String removePerm = this.plugin.getConfig().getString("permissions.admin.remove", "xjumppads.admin.remove");
        if (!sender.hasPermission(removePerm)) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("no-permission"));
            return;
        }
        if (args.length != 2) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("usage.remove"));
            return;
        }
        String name = args[1];
        if (this.jumpPadManager.getJumpPad(name) == null) {
            this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("jumppad.not-found").replace("%name%", name));
            return;
        }
        this.jumpPadManager.removeJumpPad(name, sender);
        this.sendMessage(sender, this.plugin.getMessagesFile().getConfig().getString("jumppad.removed").replace("%name%", name));
    }

    private void sendHelp(CommandSender sender) {
        this.plugin.getMessagesFile().getConfig().getStringList("help-menu").forEach(line -> sender.sendMessage(ColorUtils.colorize(line)));
    }

    private void sendMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(ColorUtils.colorize(message.replace("%prefix%", this.prefix)));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("set", "remove", "list", "reload", "help", "menu");
            return subCommands.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            return this.jumpPadManager.getAllJumpPads().stream().map(JumpPad::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("set")) {
            return Stream.of(DirectionType.values()).map(Enum::name).map(String::toLowerCase).filter(name -> name.startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

