/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.gui;

import jn.willfrydev.xjumpads.manager.JumpPad;
import jn.willfrydev.xjumpads.utils.ColorUtils;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GUIListeners
implements Listener {
    private final xJumPads plugin;

    public GUIListeners(xJumPads plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String expectedTitle = ColorUtils.colorize(this.plugin.getMessagesFile().getConfig().getString("menu.title"));
        String actualTitle = event.getView().getTitle();
        if (!actualTitle.equals(expectedTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String itemName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
        JumpPad targetPad = this.plugin.getJumpPadManager().getJumpPad(itemName);
        if (targetPad != null) {
            player.teleport(targetPad.getLocation().clone().add(0.5, 1.0, 0.5));
            player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            String prefix = this.plugin.getMessagesFile().getConfig().getString("prefix");
            String rawMessage = this.plugin.getMessagesFile().getConfig().getString("menu.teleport");
            String message = rawMessage.replace("%prefix%", prefix).replace("%name%", targetPad.getName());
            player.sendMessage(ColorUtils.colorize(message));
            player.closeInventory();
        }
    }
}

