/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jn.willfrydev.xjumpads.manager.JumpPad;
import jn.willfrydev.xjumpads.utils.ColorUtils;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final xJumPads plugin;

    public GUIManager(xJumPads plugin) {
        this.plugin = plugin;
    }

    public void openJumpPadMenu(Player player) {
        Collection<JumpPad> jumpPadCollection = this.plugin.getJumpPadManager().getAllJumpPads();
        ArrayList<JumpPad> jumpPads = new ArrayList<JumpPad>(jumpPadCollection);
        if (jumpPads.isEmpty()) {
            player.sendMessage(ColorUtils.colorize(this.plugin.getMessagesFile().getConfig().getString("prefix") + this.plugin.getMessagesFile().getConfig().getString("menu.no-pads")));
            return;
        }
        int size = (int)(Math.ceil((double)jumpPads.size() / 9.0) * 9.0);
        size = Math.min(size, 54);
        String title = ColorUtils.colorize(this.plugin.getMessagesFile().getConfig().getString("menu.title"));
        Inventory menu = Bukkit.createInventory(null, (int)size, (String)title);
        for (JumpPad pad : jumpPads) {
            ItemStack item = new ItemStack(Material.FEATHER);
            ItemMeta meta = item.getItemMeta();
            String itemName = this.plugin.getMessagesFile().getConfig().getString("menu.item-name").replace("%name%", pad.getName());
            meta.setDisplayName(ColorUtils.colorize(itemName));
            List lore = this.plugin.getMessagesFile().getConfig().getStringList("menu.item-lore").stream().map(line -> line.replace("%x%", String.valueOf(pad.getLocation().getBlockX())).replace("%y%", String.valueOf(pad.getLocation().getBlockY())).replace("%z%", String.valueOf(pad.getLocation().getBlockZ()))).map(ColorUtils::colorize).collect(Collectors.toList());
            meta.setLore(lore);
            item.setItemMeta(meta);
            menu.addItem(new ItemStack[]{item});
        }
        player.openInventory(menu);
    }
}

