/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.listeners;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import jn.willfrydev.xjumpads.api.events.PlayerUseJumpPadEvent;
import jn.willfrydev.xjumpads.manager.DirectionType;
import jn.willfrydev.xjumpads.manager.JumpPad;
import jn.willfrydev.xjumpads.manager.JumpPadManager;
import jn.willfrydev.xjumpads.utils.ColorUtils;
import jn.willfrydev.xjumpads.utils.UpdateChecker;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlayerListeners
implements Listener {
    private final xJumPads plugin;
    private final JumpPadManager jumpPadManager;
    private final Set<UUID> animatingPlayers = new HashSet<UUID>();

    public PlayerListeners(xJumPads plugin) {
        this.plugin = plugin;
        this.jumpPadManager = plugin.getJumpPadManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UpdateChecker checker;
        String notifyPermission;
        final Player player = event.getPlayer();
        if (player.hasPermission(notifyPermission = this.plugin.getConfig().getString("permissions.admin.notify", "xjumppads.admin.notify")) && (checker = this.plugin.getUpdateChecker()) != null && checker.isUpdateAvailable()) {
            new BukkitRunnable(){

                public void run() {
                    List messages = PlayerListeners.this.plugin.getConfig().getStringList("update-checker.notify-message");
                    String currentVersion = PlayerListeners.this.plugin.getDescription().getVersion();
                    String newVersion = checker.getNewVersion();
                    for (String line : messages) {
                        player.sendMessage(ColorUtils.colorize(line.replace("%current_version%", currentVersion).replace("%new_version%", newVersion)));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 40L);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.animatingPlayers.contains(player.getUniqueId())) {
            return;
        }
        String usePermission = this.plugin.getConfig().getString("permissions.use", "xjumppads.use");
        if (!player.hasPermission(usePermission)) {
            return;
        }
        Location playerPos = player.getLocation();
        JumpPad jumpPad = this.jumpPadManager.getJumpPadAt(playerPos);
        if (jumpPad == null) {
            jumpPad = this.jumpPadManager.getJumpPadAt(playerPos.subtract(0.0, 1.0, 0.0));
        }
        if (jumpPad != null) {
            boolean animationEnabled = this.plugin.getConfig().getBoolean("animation.enabled", false);
            if (animationEnabled) {
                this.playAnimationAndLaunch(player, jumpPad);
            } else {
                this.launchPlayer(player, jumpPad);
            }
        }
    }

    private void playAnimationAndLaunch(final Player player, final JumpPad jumpPad) {
        long durationTicks = this.plugin.getConfig().getLong("animation.duration", 20L);
        int amplifier = this.plugin.getConfig().getInt("animation.amplifier", 0);
        this.animatingPlayers.add(player.getUniqueId());
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, (int)durationTicks, amplifier, false, false));
        new BukkitRunnable(){

            public void run() {
                PlayerListeners.this.animatingPlayers.remove(player.getUniqueId());
                if (player.isOnline()) {
                    PlayerListeners.this.launchPlayer(player, jumpPad);
                }
            }
        }.runTaskLater((Plugin)this.plugin, durationTicks);
    }

    private void launchPlayer(Player player, JumpPad jumpPad) {
        Vector launchVector;
        DirectionType directionType = jumpPad.getDirectionType();
        double power = jumpPad.getPower();
        Location horizontalDirection = player.getLocation().clone();
        horizontalDirection.setPitch(0.0f);
        switch (directionType) {
            case UP: {
                launchVector = new Vector(0.0, power, 0.0);
                break;
            }
            case CUSTOM: {
                launchVector = horizontalDirection.getDirection().multiply(power).setY(jumpPad.getAngle());
                break;
            }
            default: {
                launchVector = horizontalDirection.getDirection().multiply(power);
            }
        }
        PlayerUseJumpPadEvent useEvent = new PlayerUseJumpPadEvent(player, jumpPad, launchVector);
        Bukkit.getPluginManager().callEvent((Event)useEvent);
        if (useEvent.isCancelled()) {
            return;
        }
        player.setVelocity(useEvent.getVelocity());
        this.playLaunchEffects(player.getLocation());
    }

    private void playLaunchEffects(Location location) {
        try {
            Sound sound = Sound.valueOf((String)this.plugin.getConfig().getString("launch-effects.sound.type", "ENTITY_ENDER_DRAGON_FLAP"));
            float volume = (float)this.plugin.getConfig().getDouble("launch-effects.sound.volume", 1.0);
            float pitch = (float)this.plugin.getConfig().getDouble("launch-effects.sound.pitch", 1.2);
            location.getWorld().playSound(location, sound, volume, pitch);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("El sonido '" + this.plugin.getConfig().getString("launch-effects.sound.type") + "' no es v\u00e1lido.");
        }
        if (this.plugin.getConfig().getBoolean("launch-effects.particles.enabled", true)) {
            try {
                Particle particle = Particle.valueOf((String)this.plugin.getConfig().getString("launch-effects.particles.type", "PORTAL"));
                int count = this.plugin.getConfig().getInt("launch-effects.particles.count", 50);
                location.getWorld().spawnParticle(particle, location, count);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("La part\u00edcula '" + this.plugin.getConfig().getString("launch-effects.particles.type") + "' no es v\u00e1lida.");
            }
        }
    }
}

