/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jn.willfrydev.xjumpads.api.events.JumpPadCreateEvent;
import jn.willfrydev.xjumpads.api.events.JumpPadRemoveEvent;
import jn.willfrydev.xjumpads.manager.DirectionType;
import jn.willfrydev.xjumpads.manager.JumpPad;
import jn.willfrydev.xjumpads.utils.FileManager;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;

public class JumpPadManager {
    private final xJumPads plugin;
    private final Map<String, JumpPad> jumpPads = new HashMap<String, JumpPad>();
    private final FileManager jumpPadsFile;

    public JumpPadManager(xJumPads plugin) {
        this.plugin = plugin;
        this.jumpPadsFile = new FileManager("jumppads.yml");
        this.loadJumpPads();
    }

    public JumpPad createJumpPad(String name, Location location, double power, DirectionType directionType, double angle, CommandSender creator) {
        JumpPad newJumpPad = new JumpPad(name, location, power, directionType, angle);
        JumpPadCreateEvent event = new JumpPadCreateEvent(newJumpPad, creator);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.jumpPads.put(name.toLowerCase(), newJumpPad);
        this.saveJumpPads();
        return newJumpPad;
    }

    public void removeJumpPad(String name, CommandSender remover) {
        JumpPad jumpPadToRemove = this.getJumpPad(name);
        if (jumpPadToRemove == null) {
            return;
        }
        JumpPadRemoveEvent event = new JumpPadRemoveEvent(jumpPadToRemove, remover);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.jumpPads.remove(name.toLowerCase());
        this.saveJumpPads();
    }

    public JumpPad getJumpPad(String name) {
        return this.jumpPads.get(name.toLowerCase());
    }

    public JumpPad getJumpPadAt(Location location) {
        Location blockLocation = location.getBlock().getLocation();
        for (JumpPad jumpPad : this.jumpPads.values()) {
            if (!jumpPad.getLocation().equals((Object)blockLocation)) continue;
            return jumpPad;
        }
        return null;
    }

    public Collection<JumpPad> getAllJumpPads() {
        return Collections.unmodifiableCollection(this.jumpPads.values());
    }

    public void loadJumpPads() {
        this.jumpPads.clear();
        ConfigurationSection section = this.jumpPadsFile.getConfig().getConfigurationSection("pads");
        if (section == null) {
            return;
        }
        for (String name : section.getKeys(false)) {
            DirectionType directionType;
            Location location = section.getLocation(name + ".location");
            double power = section.getDouble(name + ".power");
            double angle = section.getDouble(name + ".angle", 0.0);
            try {
                directionType = DirectionType.valueOf(section.getString(name + ".directionType", "FORWARD"));
            }
            catch (IllegalArgumentException e) {
                directionType = DirectionType.FORWARD;
            }
            if (location == null) continue;
            JumpPad jumpPad = new JumpPad(name, location, power, directionType, angle);
            this.jumpPads.put(name.toLowerCase(), jumpPad);
        }
    }

    public void saveJumpPads() {
        this.jumpPadsFile.getConfig().set("pads", null);
        for (JumpPad jumpPad : this.jumpPads.values()) {
            String path = "pads." + jumpPad.getName();
            this.jumpPadsFile.getConfig().set(path + ".location", (Object)jumpPad.getLocation());
            this.jumpPadsFile.getConfig().set(path + ".power", (Object)jumpPad.getPower());
            this.jumpPadsFile.getConfig().set(path + ".directionType", (Object)jumpPad.getDirectionType().name());
            this.jumpPadsFile.getConfig().set(path + ".angle", (Object)jumpPad.getAngle());
        }
        this.jumpPadsFile.save();
    }
}

