/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    private final xJumPads plugin = xJumPads.getInstance();
    private final String fileName;
    private FileConfiguration fileConfig;
    private File file;

    public FileManager(String fileName) {
        this.fileName = fileName;
        this.saveDefault();
    }

    public void reload() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
        }
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        InputStreamReader defaultConfigStream = new InputStreamReader(this.plugin.getResource(this.fileName), StandardCharsets.UTF_8);
        if (defaultConfigStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultConfigStream);
            this.fileConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfig == null) {
            this.reload();
        }
        return this.fileConfig;
    }

    public void save() {
        if (this.fileConfig == null || this.file == null) {
            return;
        }
        try {
            this.getConfig().save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("No se pudo guardar el archivo " + this.fileName);
            e.printStackTrace();
        }
    }

    public void saveDefault() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
        }
        if (!this.file.exists()) {
            if (this.plugin.getResource(this.fileName) != null) {
                this.plugin.saveResource(this.fileName, false);
            } else {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("No se pudo crear el archivo " + this.fileName);
                    e.printStackTrace();
                }
            }
        }
    }
}

