/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xjumpads.xJumPads;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final xJumPads plugin;
    private static final String MODRINTH_PROJECT_ID = "MjPDa0DW";
    private boolean isUpdateAvailable = false;
    private String newVersion = "";

    public UpdateChecker(xJumPads plugin) {
        this.plugin = plugin;
    }

    public void check() {
        if (MODRINTH_PROJECT_ID.equals("PEGA_AQUI_TU_PROJECT_ID")) {
            this.plugin.getLogger().warning("El Project ID de Modrinth no ha sido configurado en UpdateChecker.java. Las actualizaciones no se verificar\u00e1n.");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String currentVersion;
                String latestVersion;
                String inputLine;
                URL url = new URL("https://api.modrinth.com/v2/project/MjPDa0DW/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "WillfryDev/xJumPads-UpdateChecker");
                if (connection.getResponseCode() != 200) {
                    this.plugin.getLogger().warning("No se pudo verificar si hay actualizaciones (Error: " + connection.getResponseCode() + ")");
                    return;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                connection.disconnect();
                Pattern pattern = Pattern.compile("\"version_number\"\\s*:\\s*\"(.*?)\"");
                Matcher matcher = pattern.matcher(content.toString());
                if (matcher.find() && !(latestVersion = matcher.group(1)).equalsIgnoreCase(currentVersion = this.plugin.getDescription().getVersion())) {
                    this.isUpdateAvailable = true;
                    this.newVersion = latestVersion;
                    this.plugin.getLogger().info("\u00a1Hay una nueva versi\u00f3n de xJumPads disponible! Versi\u00f3n: " + latestVersion);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Ocurri\u00f3 un error al buscar actualizaciones: " + e.getMessage());
            }
        });
    }

    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public String getNewVersion() {
        return this.newVersion;
    }
}

