/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xjumpads;

import java.util.List;
import jn.willfrydev.xjumpads.api.xJumPadsAPI;
import jn.willfrydev.xjumpads.commands.CommandManager;
import jn.willfrydev.xjumpads.gui.GUIListeners;
import jn.willfrydev.xjumpads.gui.GUIManager;
import jn.willfrydev.xjumpads.listeners.PlayerListeners;
import jn.willfrydev.xjumpads.manager.JumpPadManager;
import jn.willfrydev.xjumpads.utils.ColorUtils;
import jn.willfrydev.xjumpads.utils.FileManager;
import jn.willfrydev.xjumpads.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class xJumPads
extends JavaPlugin {
    private static xJumPads instance;
    private static xJumPadsAPI api;
    private JumpPadManager jumpPadManager;
    private FileManager messagesFile;
    private FileManager jumpPadsFile;
    private GUIManager guiManager;
    private UpdateChecker updateChecker;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.messagesFile = new FileManager("messages.yml");
        this.jumpPadsFile = new FileManager("jumppads.yml");
        this.jumpPadManager = new JumpPadManager(this);
        api = new xJumPadsAPI(this.jumpPadManager);
        this.guiManager = new GUIManager(this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("xjumppads").setExecutor((CommandExecutor)commandManager);
        this.getCommand("xjumppads").setTabCompleter((TabCompleter)commandManager);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListeners(this), (Plugin)this);
        List enableMessages = this.messagesFile.getConfig().getStringList("plugin-status.on-enable");
        for (String line : enableMessages) {
            String formattedLine = line.replace("%count%", String.valueOf(this.jumpPadManager.getAllJumpPads().size()));
            Bukkit.getConsoleSender().sendMessage(ColorUtils.colorize(formattedLine));
        }
        if (this.getConfig().getBoolean("update-checker.enabled", true)) {
            this.updateChecker = new UpdateChecker(this);
            this.updateChecker.check();
        }
    }

    public void onDisable() {
        if (this.jumpPadManager != null) {
            this.jumpPadManager.saveJumpPads();
        }
        List disableMessages = this.messagesFile.getConfig().getStringList("plugin-status.on-disable");
        for (String line : disableMessages) {
            Bukkit.getConsoleSender().sendMessage(ColorUtils.colorize(line));
        }
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public static xJumPads getInstance() {
        return instance;
    }

    public static xJumPadsAPI getApi() {
        return api;
    }

    public JumpPadManager getJumpPadManager() {
        return this.jumpPadManager;
    }

    public FileManager getMessagesFile() {
        return this.messagesFile;
    }

    public FileManager getJumpPadsFile() {
        return this.jumpPadsFile;
    }

    public GUIManager getGuiManager() {
        return this.guiManager;
    }
}

