/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.adventuremodetweaks_common_neoforge.features;

import com.natamus.adventuremodetweaks_common_neoforge.config.ConfigHandler;
import com.natamus.adventuremodetweaks_common_neoforge.mixin.MinecartItemAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class MinecartCheck {
    public static boolean targetIsMinecartAndShouldBeBlocked(Entity targetEntity) {
        if (!ConfigHandler.preventBreakingMinecarts) {
            return false;
        }
        return targetEntity instanceof Minecart;
    }

    public static boolean itemIsMinecartAndCanBePlaced(Item item, Level level, BlockState targetBlockState) {
        if (!ConfigHandler.allowPlacingMinecarts) {
            return false;
        }
        if (!(item instanceof MinecartItem)) {
            return false;
        }
        return targetBlockState.getBlock() instanceof RailBlock;
    }

    public static boolean placeMinecart(Level level, Player player, BlockPos targetBlockPos, ItemStack handStack) {
        BlockState blockState = level.getBlockState(targetBlockPos);
        RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
        double offset = 0.0;
        if (railShape.isSlope()) {
            offset = 0.5;
        }
        Vec3 vec = new Vec3((double)targetBlockPos.getX() + 0.5, (double)targetBlockPos.getY() + 0.0625 + offset, (double)targetBlockPos.getZ() + 0.5);
        AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart((Level)level, (double)vec.x, (double)vec.y, (double)vec.z, ((MinecartItemAccessor)handStack.getItem()).getType(), (EntitySpawnReason)EntitySpawnReason.SPAWN_ITEM_USE, (ItemStack)handStack, (Player)player);
        if (abstractMinecart != null) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.addFreshEntity((Entity)abstractMinecart);
                serverLevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, targetBlockPos, GameEvent.Context.of((Entity)player, (BlockState)serverLevel.getBlockState(targetBlockPos.below())));
            }
            handStack.shrink(1);
            return true;
        }
        return false;
    }
}

