/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.announcement;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.usainsrht.announcement.command.AnnouncementCommand;
import me.usainsrht.announcement.command.CommandHandler;
import me.usainsrht.announcement.utils.CenterTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class Announcement
extends JavaPlugin {
    public static Announcement instance;
    public static int announcementIndex;
    public static BukkitTask timer;
    public static MiniMessage miniMessage;
    public static AnnouncementCommand command;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        command = new AnnouncementCommand(this.getConfig().getString("command.name", "announcement"), this.getConfig().getString("command.description"), this.getConfig().getString("command.usage"), new ArrayList<String>());
        CommandHandler.register("announcement", command);
        miniMessage = this.getConfig().getBoolean("use_custom_minimessage", true) ? CenterTag.centerTagMM : MiniMessage.miniMessage();
        if (timer != null) {
            timer.cancel();
        }
        timer = new BukkitRunnable(){

            public void run() {
                Announcement.announce();
            }
        }.runTaskTimer((Plugin)instance, 0L, (long)this.getConfig().getInt("delay", 300) * 20L);
    }

    public void onDisable() {
    }

    public static void reload() {
        Announcement.getInstance().reloadConfig();
        if (timer != null) {
            timer.cancel();
        }
        timer = new BukkitRunnable(){

            public void run() {
                Announcement.announce();
            }
        }.runTaskTimer((Plugin)instance, 0L, (long)Announcement.getInstance().getConfig().getInt("delay") * 20L);
    }

    public static Announcement getInstance() {
        return instance;
    }

    public static void announce() {
        List announcements = Announcement.getInstance().getConfig().isSet("announcements") ? Announcement.getInstance().getConfig().getStringList("announcements") : new ArrayList();
        if (announcements.isEmpty()) {
            return;
        }
        if (Announcement.getInstance().getConfig().getBoolean("ordered")) {
            Announcement.announce((String)announcements.get(announcementIndex % announcements.size()));
            ++announcementIndex;
        } else {
            Announcement.announce((String)announcements.get(ThreadLocalRandom.current().nextInt(announcements.size())));
        }
    }

    public static void announce(String message) {
        Announcement.announce(miniMessage.deserialize((Object)message));
    }

    public static void announce(Component message) {
        TextComponent announcement = Component.empty();
        for (String line : Announcement.getInstance().getConfig().getStringList("template")) {
            announcement = announcement.append(miniMessage.deserialize(line, (TagResolver)Placeholder.component((String)"announcement", (ComponentLike)message)));
            announcement = announcement.append((Component)Component.newline());
        }
        if (Announcement.getInstance().getConfig().getBoolean("broadcast")) {
            Bukkit.broadcast((Component)announcement);
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage((Component)announcement);
            }
        }
    }

    static {
        announcementIndex = 0;
        timer = null;
    }
}

