/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.announcement.utils;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class CenterUtil {
    public static int getWidth(char c) {
        return switch (c) {
            case '<', '>', 'f', 'k' -> 4;
            case '!', '\'', ',', '.', ':', ';', 'i', '|', '\u0131' -> 1;
            case ' ', '\"', '(', ')', '*', 'I', '[', ']', 't', '{', '}', '\u0130' -> 3;
            case '`', 'l' -> 2;
            case '@' -> 6;
            default -> 5;
        };
    }

    public static int getWidth(String text) {
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(text);
        return CenterUtil.getComponentWidth((Component)component);
    }

    public static String centeredText(String text, int length, char centerChar) {
        StringBuilder centered = new StringBuilder();
        int width = CenterUtil.getWidth(text);
        for (int compensated = 0; compensated < (length - width) / 2; compensated += CenterUtil.getWidth(centerChar) + 1) {
            centered.append(centerChar);
        }
        return String.valueOf(centered) + text;
    }

    public static int getComponentWidth(Component component) {
        int width = 0;
        String plain = PlainTextComponentSerializer.plainText().serialize(component);
        char[] chars = new char[plain.length()];
        plain.getChars(0, plain.length(), chars, 0);
        for (char c : chars) {
            width += CenterUtil.getWidth(c) + 1;
        }
        Object object = CenterUtil.getBolds(component).iterator();
        while (object.hasNext()) {
            Component child = (Component)object.next();
            width += PlainTextComponentSerializer.plainText().serialize(child).length();
        }
        return width;
    }

    public static List<Component> getBolds(Component component) {
        ArrayList<Component> newList = new ArrayList<Component>();
        if (component.hasDecoration(TextDecoration.BOLD)) {
            newList.add(component);
        } else {
            for (Component child : component.children()) {
                if (!child.hasDecoration(TextDecoration.BOLD)) continue;
                newList.add(child);
            }
        }
        return newList;
    }

    public static Component centeredComponent(Component component, int length, char centerChar) {
        int width = CenterUtil.getComponentWidth(component);
        int centerCharWidth = CenterUtil.getWidth(centerChar) + 1;
        StringBuilder centered = new StringBuilder();
        for (int compensated = 0; compensated < (length - width) / 2; compensated += centerCharWidth) {
            centered.append(centerChar);
        }
        return Component.text((String)centered.toString()).append(component);
    }
}

