/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import me.elephant1214.paperfixes.mixin.common.world.cache_densities.ExplosionAccessor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public final class CacheKey {
    private final World world;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double minX;
    private final double minY;
    private final double minZ;
    private final double maxX;
    private final double maxY;
    private final double maxZ;

    public CacheKey(Explosion explosion, AxisAlignedBB aabb) {
        this.world = ((ExplosionAccessor)explosion).getWorld();
        this.posX = explosion.getPosition().field_72450_a;
        this.posY = explosion.getPosition().field_72448_b;
        this.posZ = explosion.getPosition().field_72449_c;
        this.minX = aabb.field_72340_a;
        this.minY = aabb.field_72338_b;
        this.minZ = aabb.field_72339_c;
        this.maxX = aabb.field_72336_d;
        this.maxY = aabb.field_72337_e;
        this.maxZ = aabb.field_72334_f;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)other;
        if (Double.compare(cacheKey.posX, this.posX) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.posY, this.posY) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
            return false;
        }
        return this.world.equals(cacheKey.world);
    }

    public int hashCode() {
        int result = this.world.hashCode();
        result = 31 * result + Double.hashCode(this.posX);
        result = 31 * result + Double.hashCode(this.posY);
        result = 31 * result + Double.hashCode(this.posZ);
        result = 31 * result + Double.hashCode(this.minX);
        result = 31 * result + Double.hashCode(this.minY);
        result = 31 * result + Double.hashCode(this.minZ);
        result = 31 * result + Double.hashCode(this.maxX);
        result = 31 * result + Double.hashCode(this.maxY);
        result = 31 * result + Double.hashCode(this.maxZ);
        return result;
    }
}

