/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.LongAdder;

public class CachedSizeConcurrentLinkedQueue<E>
extends ConcurrentLinkedQueue<E> {
    private final LongAdder cachedSize = new LongAdder();

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        if (result) {
            this.cachedSize.increment();
        }
        return result;
    }

    @Override
    public E poll() {
        Object result = super.poll();
        if (result != null) {
            this.cachedSize.decrement();
        }
        return result;
    }

    @Override
    public int size() {
        return this.cachedSize.intValue();
    }
}

