/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.core;

import java.util.List;
import java.util.Set;
import me.elephant1214.paperfixes.configuration.PaperFixesConfig;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PFMixinConfigPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String target, String mixin) {
        if (!mixin.startsWith("me.elephant1214.paperfixes.mixin")) {
            return true;
        }
        if (mixin.contains("multiplayer.cache_last_chunk")) {
            return PaperFixesConfig.client.cacheLastChunk;
        }
        if (mixin.contains("fast_chests")) {
            return PaperFixesConfig.performance.fastChests;
        }
        if (mixin.contains("fast_border")) {
            return PaperFixesConfig.enableFastBorder();
        }
        if (mixin.contains("dont_offload_beacon")) {
            return PaperFixesConfig.bugfixes.dontOffloadBeaconColorUpdate;
        }
        if (mixin.contains("shulker_dupe")) {
            return PaperFixesConfig.bugfixes.fixShulkerDupe;
        }
        if (mixin.endsWith("RangedAttributeMixin")) {
            return PaperFixesConfig.bugfixes.fixMc133373;
        }
        if (mixin.contains("ignore_full_stack")) {
            return PaperFixesConfig.bugfixes.avoidItemMergeForFullStacks;
        }
        if (mixin.contains("optimize_pathfinding")) {
            return PaperFixesConfig.performance.optimizePathfinding;
        }
        if (mixin.contains("shared_random")) {
            return PaperFixesConfig.performance.sharedRandomForEntities;
        }
        if (mixin.contains("water_spawn_check")) {
            return PaperFixesConfig.bugfixes.fixWaterMobSpawnCheck;
        }
        if (mixin.contains("sort_enchants")) {
            return PaperFixesConfig.bugfixes.sortEnchantments;
        }
        if (mixin.contains("clear_packet_queue")) {
            return PaperFixesConfig.bugfixes.clearPacketQueue;
        }
        if (mixin.contains("fast_data_mgr")) {
            return PaperFixesConfig.performance.fastEntityDataMap;
        }
        if (mixin.contains("improved_tick_loop")) {
            return PaperFixesConfig.features.improvedTickLoop;
        }
        if (mixin.contains("optimize_task_queue")) {
            return PaperFixesConfig.performance.optimizedTaskQueue;
        }
        if (mixin.contains("handle_null_tile_crash")) {
            return PaperFixesConfig.bugfixes.handleNullTileCrashes;
        }
        if (mixin.endsWith("TeleporterMixin") || mixin.endsWith("NetHandlerPlayServerInvoker")) {
            return PaperFixesConfig.bugfixes.fixMc98153;
        }
        if (mixin.endsWith("ExtendedBlockStorageMixin")) {
            return PaperFixesConfig.bugfixes.fixMc80966;
        }
        if (mixin.contains("cache_densities")) {
            return PaperFixesConfig.performance.cacheBlockDensities;
        }
        if (mixin.contains("common.world.cache_last_chunk")) {
            return PaperFixesConfig.performance.cacheLastChunk;
        }
        if (mixin.contains("explosions_ignore_dead")) {
            return PaperFixesConfig.bugfixes.explosionsIgnoreDeadEntities;
        }
        if (mixin.contains("spawn_chunk_gr")) {
            return PaperFixesConfig.features.spawnChunkGamerule;
        }
        if (mixin.endsWith("ChunkGeneratorOverworldMixin")) {
            return PaperFixesConfig.bugfixes.fixMc54738;
        }
        if (mixin.contains("queue_saves")) {
            return PaperFixesConfig.performance.queueChunkSaving;
        }
        if (mixin.contains("remove_invalid_spawners")) {
            return PaperFixesConfig.bugfixes.removeInvalidMobSpawners;
        }
        if (mixin.contains("smart_region_read")) {
            return PaperFixesConfig.performance.smartRegionRead;
        }
        if (mixin.contains("trim_region_cache")) {
            return PaperFixesConfig.performance.trimRegionCache;
        }
        if (mixin.contains("compact_lut")) {
            return PaperFixesConfig.performance.compactLut;
        }
        if (mixin.contains("path_node_cache")) {
            if (mixin.contains("ChunkCacheMixin")) {
                return PaperFixesConfig.performance.pathNodeCache && !PaperFixesConfig.performance.pathingChunkCache;
            }
            return PaperFixesConfig.performance.pathNodeCache;
        }
        if (mixin.contains("pathing_chunk_cache")) {
            return PaperFixesConfig.performance.pathingChunkCache;
        }
        if (mixin.contains("dispenser_shulker_crash")) {
            return PaperFixesConfig.bugfixes.fixShulkerDispenseCrash;
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Nullable
    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

