/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.gamerule;

import me.elephant1214.paperfixes.configuration.PaperFixesConfig;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public final class SpawnChunkRule {
    public static final String SPAWN_CHUNK_RADIUS_RULE = "spawnChunkRadius";
    public static int radius = PaperFixesConfig.features.spawnChunkRadius;

    @SubscribeEvent
    public void worldLoad(@NotNull WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        GameRules rules = event.getWorld().func_82736_K();
        if (!rules.func_82765_e(SPAWN_CHUNK_RADIUS_RULE)) {
            rules.func_180262_a(SPAWN_CHUNK_RADIUS_RULE, Integer.toString(radius), GameRules.ValueType.NUMERICAL_VALUE);
        }
    }

    @SubscribeEvent
    public void worldUnload(@NotNull WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            radius = PaperFixesConfig.features.spawnChunkRadius;
        }
    }

    @SubscribeEvent
    public void gameRuleUpdate(@NotNull GameRuleChangeEvent event) {
        if (SPAWN_CHUNK_RADIUS_RULE.equals(event.getRuleName())) {
            radius = SpawnChunkRule.getRadius(event.getRules());
        }
    }

    public static int getRadius(@NotNull GameRules gameRules) {
        int spawnChunkRadius = gameRules.func_180263_c(SPAWN_CHUNK_RADIUS_RULE);
        if (spawnChunkRadius > 32 || spawnChunkRadius < 0) {
            int clamped = MathHelper.func_76125_a((int)spawnChunkRadius, (int)0, (int)32);
            gameRules.func_82764_b(SPAWN_CHUNK_RADIUS_RULE, Integer.toString(clamped));
            return clamped;
        }
        return spawnChunkRadius;
    }
}

