/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.manager;

import javax.vecmath.Vector2d;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public final class FastWorldBorder {
    private static final double MIN_POS = 1.0;
    private final WorldBorder border;
    private final Vector2d min = new Vector2d();
    private final Vector2d max = new Vector2d();
    private static FastWorldBorder INSTANCE;

    public double minX() {
        return this.min.x;
    }

    public double minZ() {
        return this.min.y;
    }

    public double maxX() {
        return this.max.x;
    }

    public double maxZ() {
        return this.max.y;
    }

    public void recompute() {
        double radius = this.border.func_177741_h() / 2.0;
        double centerX = this.border.func_177731_f();
        double centerZ = this.border.func_177721_g();
        this.min.set(this.clampPos(centerX - radius), this.clampPos(centerZ - radius));
        this.max.set(this.clampPos(centerX + radius), this.clampPos(centerZ + radius));
    }

    private double clampPos(double limit) {
        if (limit < 0.0) {
            return MathHelper.func_151237_a((double)limit, (double)(-this.border.func_177722_l()), (double)-1.0);
        }
        return MathHelper.func_151237_a((double)limit, (double)1.0, (double)this.border.func_177722_l());
    }

    private FastWorldBorder(WorldBorder border) {
        this.border = border;
        this.recompute();
    }

    public static FastWorldBorder instance() {
        return INSTANCE;
    }

    public static class Events {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void setupBorder(@NotNull WorldEvent.Load event) {
            World world = event.getWorld();
            if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
                return;
            }
            WorldBorder border = world.func_175723_af();
            INSTANCE = new FastWorldBorder(border);
            border.func_177737_a(new IBorderListener(){

                public void func_177694_a(@NotNull WorldBorder border, double newSize) {
                    INSTANCE.recompute();
                }

                public void func_177692_a(@NotNull WorldBorder border, double oldSize, double newSize, long time) {
                    INSTANCE.recompute();
                }

                public void func_177693_a(@NotNull WorldBorder border, double x, double z) {
                    INSTANCE.recompute();
                }

                public void func_177691_a(@NotNull WorldBorder border, int newTime) {
                }

                public void func_177690_b(@NotNull WorldBorder border, int newDistance) {
                }

                public void func_177696_b(@NotNull WorldBorder border, double newAmount) {
                }

                public void func_177695_c(@NotNull WorldBorder border, double newSize) {
                }
            });
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void updateBorder(@NotNull TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START || event.world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
                return;
            }
            event.world.func_175723_af().func_177741_h();
        }

        @Mod.EventHandler
        public void unloadBorder(@NotNull FMLServerStoppingEvent event) {
            INSTANCE = null;
        }
    }
}

