/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.mixin.common.lithium.pathing_chunk_cache;

import net.caffeinemc.lithium.ai.pathing.ChunkAccessHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkCache.class})
public class ChunkCacheMixin
implements ChunkAccessHelper {
    @Unique
    private static final IBlockState DEFAULT_BLOCK = Blocks.field_150350_a.func_176223_P();
    @Shadow
    protected Chunk[][] field_72817_c;
    @Shadow
    protected int field_72818_a;
    @Shadow
    protected int field_72816_b;
    @Unique
    private Chunk[] paperFixes$chunksFlat;
    @Unique
    private int paperFixes$xLen;
    @Unique
    private int paperFixes$zLen;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(World worldIn, BlockPos minPos, BlockPos maxPos, int subIn, CallbackInfo ci) {
        this.paperFixes$xLen = 1 + (maxPos.func_177958_n() >> 4) - (minPos.func_177958_n() >> 4);
        this.paperFixes$zLen = 1 + (maxPos.func_177952_p() >> 4) - (minPos.func_177952_p() >> 4);
        this.paperFixes$chunksFlat = new Chunk[this.paperFixes$xLen * this.paperFixes$zLen];
        for (int x = 0; x < this.paperFixes$xLen; ++x) {
            System.arraycopy(this.field_72817_c[x], 0, this.paperFixes$chunksFlat, x * this.paperFixes$zLen, this.paperFixes$zLen);
        }
    }

    @Overwrite
    @NotNull
    public IBlockState func_180495_p(@NotNull BlockPos pos) {
        int y = pos.func_177956_o();
        if (y >= 0 && y < 256) {
            ExtendedBlockStorage subchunk;
            Chunk chunk;
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            int chunkX = (x >> 4) - this.field_72818_a;
            int chunkZ = (z >> 4) - this.field_72816_b;
            if (chunkX >= 0 && chunkX < this.paperFixes$xLen && chunkZ >= 0 && chunkZ < this.paperFixes$zLen && (chunk = this.paperFixes$chunksFlat[chunkX * this.paperFixes$zLen + chunkZ]) != null && (subchunk = chunk.func_76587_i()[y >> 4]) != null) {
                return subchunk.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
            }
        }
        return DEFAULT_BLOCK;
    }

    @Override
    @Nullable
    public Chunk paperFixes$getChunkAt(int x, int z) {
        int chunkX = x - this.field_72818_a;
        int chunkZ = z - this.field_72816_b;
        if (chunkX >= 0 && chunkX < this.paperFixes$xLen && chunkZ >= 0 && chunkZ < this.paperFixes$zLen) {
            return this.paperFixes$chunksFlat[chunkX * this.paperFixes$zLen + chunkZ];
        }
        return null;
    }
}

