/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.mixin.common.server.improved_tick_loop;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.LockSupport;
import me.elephant1214.paperfixes.PaperFixes;
import me.elephant1214.paperfixes.configuration.PaperFixesConfig;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements ICommandSender,
Runnable,
IThreadListener,
ISnooperInfo {
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    protected long field_175591_ab;
    @Shadow
    @Final
    private ServerStatusResponse field_147147_p;
    @Shadow
    private boolean field_71317_u;
    @Shadow
    private boolean field_71316_v;
    @Shadow
    private String field_71286_C;
    @Shadow
    private boolean field_71296_Q;
    @Shadow
    @Final
    public Queue<FutureTask<?>> field_175589_i;
    @Unique
    private long paperFixes$catchupTicks = 0L;

    @Shadow
    public abstract boolean func_71197_b() throws IOException;

    @Shadow
    public abstract void func_184107_a(ServerStatusResponse var1);

    @Shadow
    public abstract void func_71217_p();

    @Shadow
    public abstract void func_71228_a(CrashReport var1);

    @Shadow
    public abstract CrashReport func_71230_b(CrashReport var1);

    @Shadow
    public abstract File func_71238_n();

    @Shadow
    public abstract void func_71260_j();

    @Shadow
    public abstract void func_71240_o();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private boolean paperFixes$tryRunTasks() {
        if (!PaperFixesConfig.features.runTasksDuringSleep) {
            return false;
        }
        Queue<FutureTask<?>> queue = this.field_175589_i;
        synchronized (queue) {
            if (!this.field_175589_i.isEmpty()) {
                Util.func_181617_a(this.field_175589_i.poll(), (Logger)field_147145_h);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Overwrite(remap=false)
    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            if (!this.func_71197_b()) {
                FMLCommonHandler.instance().expectServerStopped();
                this.func_71228_a(null);
                return;
            }
            PaperFixes.LOGGER.info("Using PaperFixes' improved tick loop, spin time {} ns", (Object)PaperFixesConfig.features.tickLoopSpinTime);
            if (PaperFixesConfig.features.runTasksDuringSleep) {
                PaperFixes.LOGGER.info("Using PaperFixes' improved task scheduler");
            }
            FMLCommonHandler.instance().handleServerStarted();
            this.field_175591_ab = System.currentTimeMillis();
            this.field_147147_p.func_151315_a((ITextComponent)new TextComponentString(this.field_71286_C));
            this.field_147147_p.func_151321_a(new ServerStatusResponse.Version("1.12.2", 340));
            this.func_184107_a(this.field_147147_p);
            long nextTickStart = System.nanoTime();
            long lastOverloadWarning = nextTickStart + 2500000000L + 15000000000L;
            while (this.field_71317_u) {
                long now = System.nanoTime();
                long nanosBehind = now - nextTickStart;
                if (nanosBehind > 2500000000L) {
                    this.paperFixes$catchupTicks = nanosBehind / 50000000L;
                    if (now - lastOverloadWarning >= 15000000000L) {
                        field_147145_h.warn("Multiple ticks took too long! Attempting to catch up by {} ticks ({} ms)", (Object)this.paperFixes$catchupTicks, (Object)(nanosBehind / 1000000L));
                        lastOverloadWarning = now;
                    }
                }
                nextTickStart += 50000000L;
                this.func_71217_p();
                this.field_175591_ab = System.currentTimeMillis();
                if (this.paperFixes$catchupTicks > 0L) {
                    --this.paperFixes$catchupTicks;
                }
                if (this.paperFixes$catchupTicks == 0L) {
                    while ((now = System.nanoTime()) < nextTickStart) {
                        long remaining = nextTickStart - now;
                        if (remaining <= (long)PaperFixesConfig.features.tickLoopSpinTime || this.paperFixes$tryRunTasks()) continue;
                        LockSupport.parkNanos(remaining);
                    }
                }
                this.field_71296_Q = true;
            }
            FMLCommonHandler.instance().handleServerStopping();
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (StartupQuery.AbortedException abort) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable unexpectedException) {
            field_147145_h.error("Encountered an unexpected exception", unexpectedException);
            CrashReport crashreport = unexpectedException instanceof ReportedException ? this.func_71230_b(((ReportedException)unexpectedException).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", unexpectedException));
            File crashReport = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(crashReport)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)crashReport.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                this.func_71260_j();
            }
            catch (Throwable var68) {
                field_147145_h.error("Exception stopping the server", var68);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.field_71316_v = true;
                this.func_71240_o();
            }
        }
    }
}

