/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.mixin.common.world.chunk.queue_saves;

import io.papermc.paper.QueuedChunk;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import me.elephant1214.paperfixes.PaperFixes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AnvilChunkLoader.class})
public abstract class AnvilChunkLoaderMixin
implements IChunkLoader,
IThreadedFileIO {
    @Shadow
    @Final
    private static Logger field_151505_a;
    @Unique
    private final ConcurrentLinkedQueue<QueuedChunk> paperFixes$queue = new ConcurrentLinkedQueue();
    @Unique
    private final Object paperFixes$lock = new Object();
    @Unique
    private final AtomicLong paperFixes$processedSaves = new AtomicLong(0L);
    @Shadow
    @Final
    public File field_75825_d;
    @Shadow
    @Final
    private Map<ChunkPos, NBTTagCompound> field_75828_a;

    @Shadow
    protected abstract void func_183013_b(ChunkPos var1, NBTTagCompound var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    protected void func_75824_a(ChunkPos pos, NBTTagCompound compound) {
        Object object = this.paperFixes$lock;
        synchronized (object) {
            this.field_75828_a.put(pos, compound);
        }
        this.paperFixes$queue.add(new QueuedChunk(pos, compound));
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)this);
    }

    @Overwrite
    public boolean func_75814_c() {
        return this.paperFixes$processSaveQueueEntry(false);
    }

    @Overwrite
    public void func_75818_b() {
        while (this.paperFixes$processSaveQueueEntry(true)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private synchronized boolean paperFixes$processSaveQueueEntry(boolean logCompletion) {
        QueuedChunk queuedChunk = this.paperFixes$queue.poll();
        if (queuedChunk == null) {
            if (logCompletion) {
                field_151505_a.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)this.field_75825_d.getName());
            }
            return false;
        }
        ChunkPos pos = queuedChunk.pos;
        this.paperFixes$processedSaves.incrementAndGet();
        NBTTagCompound compound = queuedChunk.compound;
        int attempts = 0;
        Exception lastException = null;
        while (attempts++ < 5) {
            try {
                this.func_183013_b(pos, compound);
                lastException = null;
                break;
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e2) {
                    PaperFixes.LOGGER.error((Object)e2);
                }
            }
        }
        if (lastException != null) {
            field_151505_a.error("Failed to save chunk", (Throwable)lastException);
        }
        Object object = this.paperFixes$lock;
        synchronized (object) {
            if (this.field_75828_a.get(pos) == queuedChunk.compound) {
                this.field_75828_a.remove(pos);
            }
        }
        return true;
    }
}

