/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.paperfixes.mixin.common.world.chunk.trim_region_cache;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import me.elephant1214.paperfixes.PaperFixes;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={RegionFileCache.class})
public abstract class RegionFileCacheMixin {
    @Shadow
    private static final Map<File, RegionFile> field_76553_a = new LinkedHashMap<File, RegionFile>(256, 0.75f, true);

    @Redirect(method={"createOrLoadRegionFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/RegionFileCache;clearRegionFileReferences()V"))
    private static synchronized void trimInsteadOfClearing() {
        RegionFileCacheMixin.paperFixes$trimCache();
    }

    @Unique
    private static synchronized void paperFixes$trimCache() {
        Iterator<Map.Entry<File, RegionFile>> iterator = field_76553_a.entrySet().iterator();
        int count = field_76553_a.size() - 256;
        while (count-- >= 0 && iterator.hasNext()) {
            try {
                iterator.next().getValue().func_76708_c();
            }
            catch (IOException e) {
                PaperFixes.LOGGER.error("Unable to close region file", (Throwable)e);
            }
            iterator.remove();
        }
    }
}

