/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.lithium.ai.pathing;

import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import me.elephant1214.paperfixes.mixin.common.lithium.path_node_cache.BlockStateContainerAccessor;
import net.caffeinemc.lithium.ai.pathing.BlockStatePathingCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BitArray;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public final class PathNodeCache {
    private static final Reference2BooleanMap<ExtendedBlockStorage> chunkNeighborDangerCache = new Reference2BooleanOpenHashMap();
    private static boolean dangerCacheEnabled = false;
    private static ExtendedBlockStorage prevQueriedNeighborSectionKey;
    private static boolean prevQueriedNeighborSectionResult;

    public static void enableChunkCache() {
        dangerCacheEnabled = true;
    }

    public static void disableChunkCache() {
        dangerCacheEnabled = false;
        chunkNeighborDangerCache.clear();
        prevQueriedNeighborSectionKey = null;
        prevQueriedNeighborSectionResult = false;
    }

    public static boolean isChunkSectionDangerousNeighbor(ExtendedBlockStorage section) {
        BlockStateContainer palette = section.func_186049_g();
        BitArray data = ((BlockStateContainerAccessor)palette).getStorage();
        int size = data.func_188144_b();
        for (int i = 0; i < size; ++i) {
            if (PathNodeCache.getNeighborPathNodeType(palette.func_186015_a(data.func_188142_a(i))) == PathNodeType.OPEN) continue;
            return true;
        }
        return false;
    }

    public static PathNodeType getPathNodeType(IBlockState state) {
        return ((BlockStatePathingCache)state).paperFixes$getPathNodeType();
    }

    public static PathNodeType getNeighborPathNodeType(IBlockState state) {
        return ((BlockStatePathingCache)state).paperFixes$getNeighborPathNodeType();
    }

    public static boolean isSectionSafeAsNeighbor(ExtendedBlockStorage section) {
        if (section.func_76663_a()) {
            return true;
        }
        if (!dangerCacheEnabled) {
            return false;
        }
        if (prevQueriedNeighborSectionKey != section) {
            prevQueriedNeighborSectionKey = section;
            prevQueriedNeighborSectionResult = (Boolean)chunkNeighborDangerCache.computeIfAbsent((Object)section, PathNodeCache::isChunkSectionDangerousNeighbor) == false;
        }
        return prevQueriedNeighborSectionResult;
    }
}

