/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lanse.lanses.challenge.modpack.Commands;
import lanse.lanses.challenge.modpack.InitializedListeners;
import lanse.lanses.challenge.modpack.challenges.blizzard.Blizzard;
import lanse.lanses.challenge.modpack.challenges.elytrarace.ElytraRace;
import lanse.lanses.challenge.modpack.challenges.floorislava.FloorIsLava;
import lanse.lanses.challenge.modpack.challenges.lavastorm.LavaStorm;
import lanse.lanses.challenge.modpack.challenges.lightningworld.LightningWorld;
import lanse.lanses.challenge.modpack.challenges.midastouch.MidasTouch;
import lanse.lanses.challenge.modpack.challenges.mobdoubler.MobDoubler;
import lanse.lanses.challenge.modpack.challenges.nuclearstorm.NuclearStorm;
import lanse.lanses.challenge.modpack.challenges.potionrain.PotionRain;
import lanse.lanses.challenge.modpack.challenges.wallspike.WallSpike;
import lanse.lanses.challenge.modpack.challenges.worldcorruptor.WorldCorrupter;
import lanse.lanses.challenge.modpack.storage.Database;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainControl
implements ModInitializer {
    public static final String MOD_ID = "lanses-challenge-modpack";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"lanses-challenge-modpack");
    public static boolean isModEnabled = false;
    public static Preset modPreset = Preset.NONE;
    public static int tickCount = 0;
    public static String[] weatherPresets = new String[]{"NuclearStorm", "LavaStorm", "Blizzard", "LightningWorld", "WorldCorrupter", "PotionRain"};

    public void onInitialize() {
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTick);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        InitializedListeners.register();
        Path configFolder = MainControl.getConfigFolder();
        if (!Files.exists(configFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.loadConfigFromJson(configFolder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void onServerTick(MinecraftServer server) {
        if (++tickCount > 0x7FFFFFF9) {
            tickCount = 0;
        }
        if (tickCount % 300 == 0 && Database.changed) {
            Database dataSaver = Database.getOrCreate(server);
            Path configFolder = MainControl.getConfigFolder();
            dataSaver.saveToJson(configFolder);
        }
        if (isModEnabled) {
            switch (modPreset) {
                case WALLSPIKE: {
                    WallSpike.tick(server);
                    break;
                }
                case NUCLEARSTORM: {
                    NuclearStorm.tick(server);
                    break;
                }
                case LAVASTORM: {
                    LavaStorm.tick(server);
                    break;
                }
                case BLIZZARD: {
                    Blizzard.tick(server);
                    break;
                }
                case FLOORISLAVA: {
                    FloorIsLava.tick(server);
                    break;
                }
                case LIGHTNINGWORLD: {
                    LightningWorld.tick(server);
                    break;
                }
                case WORLDCORRUPTOR: {
                    WorldCorrupter.tick(server);
                    break;
                }
                case POTIONRAIN: {
                    PotionRain.tick(server);
                    break;
                }
                case MIDASTOUCH: {
                    MidasTouch.tick(server);
                    break;
                }
                case MOBDOUBLER: {
                    MobDoubler.tick(server);
                    break;
                }
                case ELYTRARACE: {
                    ElytraRace.tick(server);
                    break;
                }
                case ALL: {
                    this.TickAll(server);
                }
            }
        }
    }

    private void TickAll(MinecraftServer server) {
        WallSpike.tick(server);
        NuclearStorm.tick(server);
        LavaStorm.tick(server);
        Blizzard.tick(server);
        FloorIsLava.tick(server);
        LightningWorld.tick(server);
        WorldCorrupter.tick(server);
        PotionRain.tick(server);
        MidasTouch.tick(server);
        MobDoubler.tick(server);
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        Commands.registerCommands(dispatcher);
    }

    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("config/lcp_challenge_pack");
    }

    private void loadConfigFromJson(Path configFolder) throws IOException {
        Path configFile = configFolder.resolve("config.json");
        if (Files.exists(configFile, new LinkOption[0]) && Files.size(configFile) > 0L) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                Gson gson = new Gson();
                JsonObject jsonConfig = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                Database.fromJson(jsonConfig);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum Preset {
        NONE,
        WALLSPIKE,
        NUCLEARSTORM,
        LAVASTORM,
        BLIZZARD,
        FLOORISLAVA,
        LIGHTNINGWORLD,
        WORLDCORRUPTOR,
        POTIONRAIN,
        MIDASTOUCH,
        MOBDOUBLER,
        MOBEXPLODER,
        ELYTRARACE,
        ALL;

    }
}

