/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.blizzard;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1627;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2386;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;

public class Blizzard {
    private static int tickCount = 0;
    private static final int LEAF_DECAY_RADIUS = 64;
    private static final List<class_2338> leavesToDecay = new ArrayList<class_2338>();
    private static final ArrayList<Object> mobIdList = new ArrayList();
    private static class_6880<class_8110> freezeDamageType;

    private static void initializeFreezeDamageType(class_3218 world) {
        freezeDamageType = (class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40264(class_8111.field_42354).orElseThrow();
    }

    public static void tick(MinecraftServer server) {
        if (++tickCount % 10000 == 0) {
            leavesToDecay.clear();
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469();
            if (world.method_27983() != class_1937.field_25180) {
                Blizzard.spawnParticles(player.method_19538(), world);
                Blizzard.placeSnow(world, player.method_19538());
                if (tickCount % 500 == 0) {
                    Blizzard.scheduleLeafDecay(world, player.method_24515());
                }
            }
            Blizzard.RegulateTemperature(world);
        }
        Blizzard.processLeafDecay(server);
        mobIdList.clear();
    }

    public static void onEntitySpawn(class_1297 entity, class_3218 world) {
        if (world.method_27983() == class_1937.field_25180) {
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1299 entityType = entity.method_5864();
        if (entityType != class_1299.field_6098 && entityType != class_1299.field_6116 && entityType != class_1299.field_6097) {
            int maxStrays = 80 * world.method_18456().size();
            int currentStrays = 0;
            entity.method_31472();
            for (class_1297 ignored : world.method_18198((class_5575)class_1299.field_6098, Objects::nonNull)) {
                if (++currentStrays < maxStrays) continue;
                return;
            }
            class_1627 stray = new class_1627(class_1299.field_6098, (class_1937)world);
            stray.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
            if (new Random().nextBoolean()) {
                stray.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
            } else {
                stray.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8371));
            }
            stray.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
            stray.method_6019(class_1268.field_5808);
            world.method_8649((class_1297)stray);
        }
    }

    private static void RegulateTemperature(class_3218 world) {
        Blizzard.initializeFreezeDamageType(world);
        for (class_3222 player : world.method_18456()) {
            int radius = 64;
            class_238 boundingBox = new class_238(player.method_23317() - (double)radius, (double)world.method_31607(), player.method_23321() - (double)radius, player.method_23317() + (double)radius, (double)world.method_31600(), player.method_23321() + (double)radius);
            world.method_8390(class_1309.class, boundingBox, entity -> true).forEach(entity -> {
                if (mobIdList.contains(entity.method_5628())) {
                    return;
                }
                mobIdList.add(entity.method_5628());
                if (world.method_27983() == class_1937.field_25180) {
                    entity.method_32317(entity.method_32312() - 5);
                    return;
                }
                if (entity.method_5864() != class_1299.field_6098) {
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)entity;
                        if (serverPlayer.field_13974.method_14257() == class_1934.field_9220 || serverPlayer.field_13974.method_14257() == class_1934.field_9219) {
                            return;
                        }
                    }
                    class_2338 entityPos = entity.method_24515();
                    boolean isInDanger = true;
                    boolean leatherDamage = false;
                    boolean extraFreeze = false;
                    int dangerLevel = 7;
                    Random random = new Random();
                    int leatherArmorCount = 0;
                    for (class_1799 armorItem : entity.method_5661()) {
                        class_1738 armor;
                        class_1792 patt6355$temp = armorItem.method_7909();
                        if (!(patt6355$temp instanceof class_1738) || (armor = (class_1738)patt6355$temp).method_7686() != class_1740.field_7897) continue;
                        ++leatherArmorCount;
                    }
                    if (random.nextInt(leatherArmorCount + 1) <= 1) {
                        leatherDamage = true;
                    }
                    for (int i = 1; i <= 15; ++i) {
                        class_2338 checkPos = entityPos.method_10086(i);
                        if (world.method_22347(checkPos)) continue;
                        isInDanger = false;
                        break;
                    }
                    if (isInDanger) {
                        dangerLevel = 10;
                        extraFreeze = true;
                    }
                    entity.method_32317(Math.max(0, entity.method_32312() + 2));
                    if (tickCount % 25 == 0) {
                        if (world.method_8314(class_1944.field_9282, entity.method_24515()) < dangerLevel) {
                            entity.method_32319(true);
                            double freezeIncrement = Math.max(0, 6 - leatherArmorCount);
                            if (extraFreeze) {
                                freezeIncrement *= 1.4;
                            }
                            entity.method_32317((int)Math.min((double)entity.method_32315(), (double)entity.method_32312() + freezeIncrement));
                            if (entity.method_32312() >= entity.method_32315() && leatherDamage) {
                                entity.method_5643(new class_1282(freezeDamageType), 1.0f);
                            }
                        } else {
                            entity.method_32317(Math.max(0, entity.method_32312() - world.method_22339(entity.method_24515())));
                        }
                    }
                    boolean shouldApplyFOVEffect = player.method_32312() > 25;
                    int power = player.method_32312() / 25;
                    Blizzard.maintainFOV(player, shouldApplyFOVEffect, power);
                }
            });
        }
    }

    private static void maintainFOV(class_3222 player, boolean applyEffect, int power) {
        if (applyEffect) {
            player.method_6092(new class_1293(class_1294.field_5909, 300, power, false, false, false));
        } else {
            player.method_6016(class_1294.field_5909);
        }
    }

    private static void spawnParticles(class_243 playerPos, class_3218 world) {
        int particleRange = 20;
        Random random = new Random();
        class_2400 snowflake = class_2398.field_23956;
        for (int i = 0; i < 300; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetY = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            world.method_14199((class_2394)snowflake, playerPos.field_1352 + offsetX, playerPos.field_1351 + offsetY, playerPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.15);
        }
    }

    private static void scheduleLeafDecay(class_3218 world, class_2338 playerPos) {
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        int startX = playerPos.method_10263() - 64;
        int startY = playerPos.method_10264() - 64;
        int startZ = playerPos.method_10260() - 64;
        int endX = playerPos.method_10263() + 64;
        int endY = playerPos.method_10264() + 64;
        int endZ = playerPos.method_10260() + 64;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                    leavesToDecay.add(pos);
                }
            }
        }
    }

    private static void processLeafDecay(MinecraftServer server) {
        if (!leavesToDecay.isEmpty()) {
            int clearAmount = leavesToDecay.size() / 400 + 1;
            class_3218 world = server.method_3847(class_1937.field_25179);
            for (int i = 0; i < clearAmount; ++i) {
                int randomIndex = new Random().nextInt(leavesToDecay.size());
                class_2338 pos = leavesToDecay.get(randomIndex);
                if (pos == null || world == null || !(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                leavesToDecay.remove(randomIndex);
            }
        }
    }

    private static void checkAndFreezeWater(class_1937 world, class_2338 targetPos) {
        class_2338[] surroundingPositions;
        for (class_2338 pos : surroundingPositions = new class_2338[]{targetPos.method_10095(), targetPos.method_10072(), targetPos.method_10078(), targetPos.method_10067(), targetPos.method_10095().method_10078(), targetPos.method_10095().method_10067(), targetPos.method_10072().method_10078(), targetPos.method_10072().method_10067()}) {
            class_2680 surroundingBlockState = world.method_8320(pos);
            if (!surroundingBlockState.method_26216((class_1922)world, pos) && surroundingBlockState.method_26204() != class_2246.field_10295) continue;
            world.method_8501(targetPos, class_2246.field_10295.method_9564());
            return;
        }
    }

    private static void placeSnow(class_3218 world, class_243 playerPos) {
        int SEARCH_RADIUS = 128;
        double WEIGHT_EXPONENT = 1.2;
        Random random = new Random();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = Math.pow(random.nextDouble(), 1.2) * 128.0;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        int targetX = (int)Math.round(playerPos.field_1352 + offsetX);
        int targetZ = (int)Math.round(playerPos.field_1350 + offsetZ);
        class_2338 targetPos = new class_2338(targetX, world.method_31600(), targetZ);
        if ((targetPos = world.method_8598(class_2902.class_2903.field_13203, targetPos)).method_10264() < 5 && world.method_27983() == class_1937.field_25181) {
            return;
        }
        if (world.method_8314(class_1944.field_9282, targetPos) >= 9) {
            return;
        }
        if (world.method_8320(targetPos.method_10074()).method_26204() == class_2246.field_10382 && (Integer)world.method_8320(targetPos.method_10074()).method_11654((class_2769)class_2404.field_11278) == 0) {
            Blizzard.checkAndFreezeWater((class_1937)world, targetPos.method_10074());
            return;
        }
        if (world.method_8320(targetPos).method_26204() instanceof class_2404 || world.method_8320(targetPos.method_10074()).method_26204() instanceof class_2404) {
            return;
        }
        if (world.method_8320(targetPos.method_10074()).method_26204() instanceof class_2386) {
            return;
        }
        if (world.method_8320(targetPos).method_26204() instanceof class_2261 && !world.method_8320(targetPos).method_26225()) {
            world.method_8652(targetPos, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(1)), 3);
            return;
        }
        while (targetPos.method_10264() < 318) {
            if (world.method_8320(targetPos).method_26204() == class_2246.field_10124) {
                world.method_8652(targetPos, class_2246.field_10477.method_9564(), 3);
                return;
            }
            if (world.method_8320(targetPos).method_26204() instanceof class_2488) {
                int currentLayers = (Integer)world.method_8320(targetPos).method_11654((class_2769)class_2488.field_11518);
                if (currentLayers < 8) {
                    world.method_8652(targetPos, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(currentLayers + 1)), 3);
                    return;
                }
                targetPos = targetPos.method_10084();
                continue;
            }
            targetPos = targetPos.method_10084();
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_Preset_Blizzard").requires(source -> source.method_9259(2))).executes(context -> {
            MainControl.modPreset = MainControl.Preset.BLIZZARD;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Challenge Mod Preset set to Blizzard!"), true);
            return 1;
        }));
    }
}

