/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.elytrarace;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;

public class ElytraRace {
    private static int tickCount = 0;
    public static boolean isRacing = false;
    public static boolean raceBegun = false;
    private static boolean canPlaceLanterns = true;
    private static float originalDirection = 0.0f;
    private static TurnState currentTurn = TurnState.STRAIGHT;
    private static int turnTicksRemaining = 0;
    private static class_1531 raceBeacon;
    private static Map<UUID, Double> playerScores;
    private static Set<UUID> eliminatedPlayers;
    private static class_3218 raceWorld;
    private static final int COUNTDOWN_START_TICKS = 100;
    private static final int COUNTDOWN_INTERVAL = 20;
    private static final int RACE_DISTANCE_LIMIT = 1500;
    private static int raceLength;

    public static void tick(MinecraftServer server) {
        if (!isRacing) {
            return;
        }
        ++tickCount;
        if (!raceBegun) {
            int secondsLeft;
            if (tickCount % 20 == 0 && tickCount <= 100 && (secondsLeft = (100 - tickCount) / 20 + 1) >= 1 && secondsLeft <= 5) {
                ElytraRace.broadcastChat(server, (class_2561)class_2561.method_43470((String)String.valueOf(secondsLeft)));
            }
            if (tickCount == 101) {
                raceBegun = true;
                ElytraRace.initializePlayerScores(server);
                ElytraRace.broadcastChat(server, (class_2561)class_2561.method_43470((String)"GO!"));
            }
            return;
        }
        canPlaceLanterns = true;
        ElytraRace.updatePlayerScores();
        ElytraRace.advanceRaceBeacon();
        if (ElytraRace.allPlayersEliminatedOrFinished()) {
            ElytraRace.endRace(server);
        }
    }

    private static void advanceRaceBeacon() {
        double moveDelta;
        if (raceBeacon == null) {
            return;
        }
        class_243 beaconPos = raceBeacon.method_19538();
        class_3222 nearest = null;
        double bestDist = Double.MAX_VALUE;
        for (UUID uuid : playerScores.keySet()) {
            double distance;
            class_3222 player;
            if (eliminatedPlayers.contains(uuid) || (player = raceWorld.method_8503().method_3760().method_14602(uuid)) == null || !((distance = player.method_19538().method_1022(beaconPos)) < bestDist)) continue;
            bestDist = distance;
            nearest = player;
        }
        if (nearest == null) {
            return;
        }
        if (bestDist <= 5.0) {
            moveDelta = 3.0;
        } else if (bestDist <= 20.0) {
            moveDelta = 2.0;
        } else if (bestDist <= 85.0) {
            moveDelta = 1.0;
        } else {
            return;
        }
        if (turnTicksRemaining <= 0) {
            currentTurn = currentTurn == TurnState.UP || currentTurn == TurnState.DOWN || raceBeacon.method_23318() > 200.0 || raceBeacon.method_23318() < 0.0 ? TurnState.RESURFACE : TurnState.values()[new Random().nextInt(TurnState.values().length)];
            turnTicksRemaining = 25 + new Random().nextInt(76);
        }
        --turnTicksRemaining;
        float yaw = raceBeacon.method_36454();
        float illegalDirection = (originalDirection + 180.0f) % 360.0f;
        class_243 pos = raceBeacon.method_19538();
        for (int i = 0; i < (int)moveDelta; ++i) {
            switch (currentTurn) {
                case LEFT: {
                    yaw = (yaw - 1.0f + 360.0f) % 360.0f;
                    float angleDiff = Math.abs(class_3532.method_15393((float)(yaw - illegalDirection)));
                    if (!(angleDiff < 90.0f)) break;
                    yaw = (illegalDirection + (yaw > illegalDirection ? 90.0f : -90.0f) + 360.0f) % 360.0f;
                    break;
                }
                case RIGHT: {
                    yaw = (yaw + 1.0f + 360.0f) % 360.0f;
                    float angleDiff = Math.abs(class_3532.method_15393((float)(yaw - illegalDirection)));
                    if (!(angleDiff < 90.0f)) break;
                    yaw = (illegalDirection + (yaw > illegalDirection ? 90.0f : -90.0f) + 360.0f) % 360.0f;
                }
            }
            double rad = Math.toRadians(yaw);
            class_243 forward = new class_243(-Math.sin(rad), 0.0, Math.cos(rad)).method_1029();
            switch (currentTurn) {
                case UP: {
                    pos = pos.method_1031(forward.field_1352, 1.0, forward.field_1350);
                    break;
                }
                case DOWN: {
                    pos = pos.method_1031(forward.field_1352, -1.0, forward.field_1350);
                    break;
                }
                case LEFT: 
                case RIGHT: 
                case STRAIGHT: {
                    pos = pos.method_1019(forward);
                    break;
                }
                case RESURFACE: {
                    class_2248 block;
                    class_2338 checkPos = class_2338.method_49638((class_2374)pos);
                    class_2338 top = raceWorld.method_8598(class_2902.class_2903.field_13202, checkPos);
                    while (top.method_10264() > raceWorld.method_31607() && ((block = raceWorld.method_8320(top).method_26204()) == class_2246.field_10038 || block == class_2246.field_10085 || block == class_2246.field_16541 || block == class_2246.field_10124)) {
                        top = top.method_10074();
                    }
                    int targetY = top.method_10264() + 3;
                    double dy = pos.field_1351 < (double)targetY ? 1.0 : (double)(pos.field_1351 > (double)targetY ? -1 : 0);
                    pos = pos.method_1031(forward.field_1352, dy, forward.field_1350);
                }
            }
            ElytraRace.layTrackAt(class_2338.method_49638((class_2374)pos), yaw);
        }
        raceBeacon.method_20620(pos.field_1352, pos.field_1351, pos.field_1350);
        raceBeacon.method_36456(yaw);
    }

    private static void layTrackAt(class_2338 center, float direction) {
        int[] ends;
        class_243 offset;
        int dz;
        int dx;
        double radians = Math.toRadians(direction);
        class_243 forward = new class_243(Math.cos(radians), 0.0, Math.sin(radians));
        boolean isEastWest = Math.abs(forward.field_1352) > Math.abs(forward.field_1350);
        forward = isEastWest ? new class_243(Math.signum(forward.field_1352), 0.0, 0.0) : new class_243(0.0, 0.0, Math.signum(forward.field_1350));
        class_243 right = new class_243(-forward.field_1350, 0.0, forward.field_1352);
        int halfWidth = 0;
        int halfLength = 4;
        int cx = center.method_10263();
        int y = center.method_10264();
        int cz = center.method_10260();
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -halfLength; dz <= halfLength; ++dz) {
                offset = right.method_1021((double)dx).method_1019(forward.method_1021((double)dz));
                for (int dy = 0; dy <= 5; ++dy) {
                    class_2338 clearPos = new class_2338(cx + (int)offset.field_1352, y + dy + 1, cz + (int)offset.field_1350);
                    if (raceWorld.method_8320(clearPos).method_26204() == class_2246.field_10038) continue;
                    raceWorld.method_8652(clearPos, class_2246.field_10124.method_9564(), 3);
                }
            }
        }
        for (dx = -halfWidth; dx <= halfWidth; ++dx) {
            for (dz = -halfLength; dz <= halfLength; ++dz) {
                offset = right.method_1021((double)dx).method_1019(forward.method_1021((double)dz));
                class_2338 roadPos = new class_2338(cx + (int)offset.field_1352, y, cz + (int)offset.field_1350);
                raceWorld.method_8652(roadPos, class_2246.field_10038.method_9564(), 3);
            }
        }
        for (int dz2 : ends = new int[]{-halfLength, halfLength}) {
            class_243 leftEdge = right.method_1021(-1.0).method_1019(forward.method_1021((double)dz2));
            class_243 rightEdge = right.method_1021(1.0).method_1019(forward.method_1021((double)dz2));
            class_2338 leftPos = new class_2338(cx + (int)leftEdge.field_1352, y, cz + (int)leftEdge.field_1350);
            class_2338 rightPos = new class_2338(cx + (int)rightEdge.field_1352, y, cz + (int)rightEdge.field_1350);
            raceWorld.method_8652(leftPos, class_2246.field_10085.method_9564(), 3);
            raceWorld.method_8652(rightPos, class_2246.field_10085.method_9564(), 3);
        }
        if (tickCount % 4 == 0 && canPlaceLanterns) {
            for (int dz3 : ends) {
                class_243 left = right.method_1021(-1.0).method_1019(forward.method_1021((double)dz3));
                class_243 rightV = right.method_1021(1.0).method_1019(forward.method_1021((double)dz3));
                class_2338 l1Pos = new class_2338(cx + (int)left.field_1352, y + 1, cz + (int)left.field_1350);
                class_2338 l2Pos = new class_2338(cx + (int)rightV.field_1352, y + 1, cz + (int)rightV.field_1350);
                raceWorld.method_8652(l1Pos, class_2246.field_16541.method_9564(), 3);
                raceWorld.method_8652(l2Pos, class_2246.field_16541.method_9564(), 3);
            }
            canPlaceLanterns = false;
        }
    }

    private static void broadcastChat(MinecraftServer server, class_2561 message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }

    private static void initRaceBeacon(class_3218 world, class_2338 startPos) {
        raceWorld = world;
        if (raceWorld == null) {
            return;
        }
        raceBeacon = new class_1531((class_1937)raceWorld, (double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260());
        raceBeacon.method_5684(true);
        raceBeacon.method_5875(true);
        raceBeacon.method_5834(true);
        raceBeacon.method_5665((class_2561)class_2561.method_43470((String)"RaceBeacon"));
        raceBeacon.method_5880(false);
        raceBeacon.method_5673(class_1304.field_6174, class_1802.field_8833.method_7854());
        raceWorld.method_8649((class_1297)raceBeacon);
    }

    private static void initializePlayerScores(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            playerScores.put(player.method_5667(), 0.0);
        }
    }

    private static void updatePlayerScores() {
        if (raceBeacon == null) {
            return;
        }
        List online = raceWorld.method_8503().method_3760().method_14571();
        for (class_3222 player : online) {
            UUID uuid = player.method_5667();
            if (eliminatedPlayers.contains(uuid)) continue;
            double dist = player.method_19538().method_1022(raceBeacon.method_19538());
            if (dist > 1500.0) {
                eliminatedPlayers.add(uuid);
                player.method_7353((class_2561)class_2561.method_43470((String)"You were too far (>1500). Eliminated!"), false);
                continue;
            }
            double delta = dist / 10.0;
            playerScores.put(uuid, playerScores.get(uuid) + delta);
            if (tickCount % 20 != 0) continue;
            class_1799 rocket = new class_1799((class_1935)class_1802.field_8639);
            class_2487 nbt = new class_2487();
            class_2487 fireworks = new class_2487();
            fireworks.method_10567("Flight", (byte)3);
            nbt.method_10566("Fireworks", (class_2520)fireworks);
            rocket.method_7980(nbt);
            player.method_31548().method_7394(rocket);
        }
    }

    private static boolean allPlayersEliminatedOrFinished() {
        if (tickCount > raceLength) {
            return true;
        }
        for (UUID uuid : playerScores.keySet()) {
            class_3222 p;
            if (eliminatedPlayers.contains(uuid) || (p = raceWorld.method_8503().method_3760().method_14602(uuid)) == null) continue;
            return false;
        }
        return true;
    }

    private static void endRace(MinecraftServer server) {
        List ranking = playerScores.entrySet().stream().map(entry -> Map.entry((UUID)entry.getKey(), (Double)entry.getValue() / (double)tickCount)).sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).toList();
        isRacing = false;
        raceBegun = false;
        tickCount = 0;
        server.method_3760().method_14571().forEach(p -> {
            p.method_7353((class_2561)class_2561.method_43470((String)"=== Race Results ==="), false);
            for (int i = 0; i < ranking.size(); ++i) {
                UUID u = (UUID)((Map.Entry)ranking.get(i)).getKey();
                double score = (Double)((Map.Entry)ranking.get(i)).getValue();
                String name = Optional.ofNullable(server.method_3760().method_14602(u)).map(class_1657::method_5820).orElse("Unknown");
                p.method_7353((class_2561)class_2561.method_43470((String)(i + 1 + ". " + name + ": " + String.format("%.1f", score))), false);
            }
        });
        if (raceBeacon != null && !raceBeacon.method_31481()) {
            raceBeacon.method_5768();
            raceBeacon.method_5650(class_1297.class_5529.field_26999);
        }
        playerScores.clear();
        eliminatedPlayers.clear();
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_ElytraRace_START").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int seconds = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            assert (player != null);
            originalDirection = player.method_36454();
            raceLength = seconds * 20;
            tickCount = 0;
            isRacing = true;
            raceBegun = false;
            currentTurn = TurnState.STRAIGHT;
            turnTicksRemaining = 160;
            playerScores = new LinkedHashMap<UUID, Double>();
            eliminatedPlayers = new HashSet<UUID>();
            MainControl.modPreset = MainControl.Preset.ELYTRARACE;
            MainControl.isModEnabled = true;
            ElytraRace.initRaceBeacon(((class_2168)ctx.getSource()).method_9225().method_8410(), Objects.requireNonNull(((class_2168)ctx.getSource()).method_44023()).method_24515());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("Elytra Race will begin in 5 seconds! Race Duration: " + seconds + "s")), true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_ElytraRace_END").requires(src -> src.method_9259(2))).executes(context -> {
            ElytraRace.endRace(((class_2168)context.getSource()).method_9211());
            return 0;
        }));
    }

    static {
        raceLength = 0;
    }

    private static enum TurnState {
        STRAIGHT,
        LEFT,
        RIGHT,
        UP,
        DOWN,
        RESURFACE;

    }
}

