/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.lavastorm;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LavaStorm {
    private static int tickCount = 0;
    private static final int LEAF_DECAY_RADIUS = 64;
    private static final List<class_2338> leavesToDecay = new ArrayList<class_2338>();

    public static void tick(MinecraftServer server) {
        ++tickCount;
        Random random = new Random();
        if (random.nextInt(30) == 25) {
            LavaStorm.startFires(server);
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469();
            LavaStorm.spawnParticles(player.method_19538(), world);
            LavaStorm.skyCheck(world);
            if (tickCount != 500) continue;
            LavaStorm.scheduleLeafDecay(world, player.method_24515());
            tickCount = 0;
        }
        LavaStorm.processLeafDecay(server);
    }

    private static void startFires(MinecraftServer server) {
        Random random = new Random();
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469();
            class_2338 playerPos = player.method_24515();
            for (int i = 5 + random.nextInt(10); i > 0; --i) {
                int dz;
                int dx = random.nextInt(101) - 50;
                class_2338 targetPos = playerPos.method_10069(dx, 0, dz = random.nextInt(101) - 50);
                class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, targetPos);
                if (!world.method_8320(surfacePos).method_26215()) continue;
                world.method_8652(surfacePos, class_2246.field_10036.method_9564(), 3);
            }
        }
    }

    private static void skyCheck(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            int radius = 64;
            class_238 boundingBox = new class_238(player.method_23317() - (double)radius, (double)world.method_31607(), player.method_23321() - (double)radius, player.method_23317() + (double)radius, (double)world.method_31600(), player.method_23321() + (double)radius);
            world.method_8390(class_1309.class, boundingBox, entity -> true).forEach(entity -> {
                class_2338 entityPos = entity.method_24515();
                boolean isInDanger = true;
                for (int i = 1; i <= 15; ++i) {
                    class_2338 checkPos = entityPos.method_10086(i);
                    if (world.method_22347(checkPos)) continue;
                    isInDanger = false;
                    break;
                }
                if (isInDanger) {
                    entity.method_5639(1);
                }
            });
        }
    }

    private static void spawnParticles(class_243 playerPos, class_3218 world) {
        int particleRange = 42;
        Random random = new Random();
        class_2394[] lavaParticles = new class_2394[]{class_2398.field_11223, class_2398.field_11239, class_2398.field_28076, class_2398.field_28077, class_2398.field_18304};
        for (int i = 0; i < 350; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            class_2394 chosenParticle = lavaParticles[random.nextInt(lavaParticles.length)];
            world.method_14199(chosenParticle, playerPos.field_1352 + offsetX, playerPos.field_1351 + 15.0, playerPos.field_1350 + offsetZ, 1, 0.0, -0.5, 0.0, 0.0);
        }
    }

    private static void scheduleLeafDecay(class_3218 world, class_2338 playerPos) {
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        int startX = playerPos.method_10263() - 64;
        int startY = playerPos.method_10264() - 64;
        int startZ = playerPos.method_10260() - 64;
        int endX = playerPos.method_10263() + 64;
        int endY = playerPos.method_10264() + 64;
        int endZ = playerPos.method_10260() + 64;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                    leavesToDecay.add(pos);
                }
            }
        }
    }

    private static void processLeafDecay(MinecraftServer server) {
        if (!leavesToDecay.isEmpty()) {
            int clearAmount = leavesToDecay.size() / 250 + 1;
            class_3218 world = server.method_3847(class_1937.field_25179);
            for (int i = 0; i < clearAmount; ++i) {
                int randomIndex = new Random().nextInt(leavesToDecay.size());
                class_2338 pos = leavesToDecay.get(randomIndex);
                if (pos == null || world == null || !(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                leavesToDecay.remove(randomIndex);
            }
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_Preset_LavaStorm").requires(source -> source.method_9259(2))).executes(context -> {
            MainControl.modPreset = MainControl.Preset.LAVASTORM;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Challenge Mod Preset set to LavaStorm!"), true);
            return 1;
        }));
    }
}

