/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.lightningworld;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class LightningWorld {
    private static final int TICKS_PER_MINUTE = 1200;
    private static int tickCounter = 0;
    private static final Set<UUID> hitEntities = new HashSet<UUID>();

    public static void tick(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            world.method_18456().forEach(player -> LightningWorld.spawnLightningRodParticles(player.method_19538(), world));
        }
        if (++tickCounter >= 1200) {
            tickCounter = 0;
            hitEntities.clear();
            for (class_3218 world : server.method_3738()) {
                world.method_18456().forEach(player -> {
                    int radius = 128;
                    class_238 boundingBox = new class_238(player.method_23317() - (double)radius, (double)world.method_31607(), player.method_23321() - (double)radius, player.method_23317() + (double)radius, (double)world.method_31600(), player.method_23321() + (double)radius);
                    world.method_8390(class_1309.class, boundingBox, entity -> true).forEach(entity -> {
                        if (!hitEntities.contains(entity.method_5667())) {
                            LightningWorld.strikeEntity(entity, world);
                        }
                    });
                });
            }
        }
    }

    private static void strikeEntity(class_1309 entity, class_3218 world) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)world);
        if (lightning != null) {
            lightning.method_24203(entity.method_23317(), entity.method_23318(), entity.method_23321());
            world.method_8649((class_1297)lightning);
            hitEntities.add(entity.method_5667());
            hitEntities.add(lightning.method_5667());
        }
    }

    private static void spawnLightningRodParticles(class_243 playerPos, class_3218 world) {
        int particleRange = 42;
        class_5819 random = world.method_8409();
        class_2394[] commonParticles = new class_2394[]{class_2398.field_29644, class_2398.field_29643, class_2398.field_11207};
        class_2394[] rareParticles = new class_2394[]{class_2398.field_11248, class_2398.field_11203, class_2398.field_11228, class_2398.field_11204, class_2398.field_22248};
        for (int i = 0; i < 25; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 2.0 * (double)particleRange;
            double offsetY = (random.method_43058() - 0.5) * 2.0 * (double)particleRange;
            double offsetZ = (random.method_43058() - 0.5) * 2.0 * (double)particleRange;
            class_2394 particle = random.method_43048(100) < 95 ? commonParticles[random.method_43048(commonParticles.length)] : rareParticles[random.method_43048(rareParticles.length)];
            if (particle == class_2398.field_11204) {
                world.method_14199(particle, playerPos.field_1352 + offsetX, playerPos.field_1351 + offsetY, playerPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 1.0);
                continue;
            }
            world.method_14199(particle, playerPos.field_1352 + offsetX, playerPos.field_1351 + offsetY, playerPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_Preset_LightningWorld").requires(source -> source.method_9259(2))).executes(context -> {
            MainControl.modPreset = MainControl.Preset.LIGHTNINGWORLD;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Challenge Mod Preset set to LightningWorld!"), true);
            return 1;
        }));
    }
}

